% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{steps}
\alias{steps}
\title{Implements StEPS and StARS for MGM}
\usage{
steps(
  data,
  lambdas = NULL,
  nLambda = 30L,
  gamma = 0.05,
  numSub = 20L,
  subSize = -1L,
  leaveOneOut = FALSE,
  threads = -1L,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{lambdas}{A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.}

\item{nLambda}{A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.}

\item{gamma}{The threshold for edge instability. The default value is 0.05, and it is not recommended to change this value.}

\item{numSub}{The number of subsamples of the dataset used to estimate edge instability. The default value is 20.}

\item{subSize}{The number of samples to be drawn without replacement for each subsample. The default value is -1. When subSize is -1, it is set to min(floor(0.75 * N), floor(10*sqrt(N))), where N is the number of samples.}

\item{leaveOneOut}{If TRUE, performs leave-one-out subsampling. Defaults to FALSE.}

\item{threads}{An integer value denoting the number of threads to use for parallelization of learning MGMs across subsamples. The default value is -1, which will all available CPUs.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphSTEPS object containing the MGMs selected by StEPS and StARS, as well as the instability of each edge type at each value of lambda.
}
\description{
Calculates the optimal lambda values for the MGM algorithm using StEPS and StARS. Returns a graphSTEPS object that contains the MGMs selected by StEPS and StARS as well as the instability at each value of lambda.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
ig.steps <- steps(sim$data)
print(ig.steps)
}
}
