% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{skeleton}
\alias{skeleton}
\title{Calculate the undirected skeleton for a given DAG}
\usage{
skeleton(graph)
}
\arguments{
\item{graph}{The graph object used to generate the skeleton graph. Should be the ground-truth causal DAG}
}
\value{
The skeleton graph corresponding to the input DAG
}
\description{
Create the skeleton graph for the input directed acyclic graph (DAG). The skeleton graph is the undirected graph that contains the same adjacencies as the input DAG.
}
\examples{
sim <- simRandomDAG(200, 25, deg=2)
sim$skeleton <- skeleton(sim$graph)
print(sim$skeleton)
}
