% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFunctions.R
\name{simRandomDAG}
\alias{simRandomDAG}
\title{A function to simulate a random forward DAG from a SEM model.}
\usage{
simRandomDAG(
  n = 1000,
  p = 50,
  r = 0,
  discFrac = 0.5,
  deg = 3,
  coefMin = 0.5,
  coefMax = 1.5,
  noiseMin = 1,
  noiseMax = 2,
  censorRate = 0.3,
  seed = NULL
)
}
\arguments{
\item{n}{The sample size of the generated dataset. The default is
1000.}

\item{p}{The number of features in the generated dataset. The
default is 50.}

\item{r}{The number of censored features in the generated
dataset. The default is 0.}

\item{discFrac}{The fraction of variables in the dataset that are
discrete. The default is 0.5.}

\item{deg}{The average graph degree for the simulated graph. The
default is 3.}

\item{coefMin}{The lower bound on the magnitude of the effect
size. The default is 0.5.}

\item{coefMax}{The upper bound on the magnitude of the effect
size. The default is 1.5.}

\item{noiseMin}{The lower bound on the standard deviation of the
Gaussian noise for continuous variables. The default is 1.}

\item{noiseMax}{The upper bound on the standard deviation of the
Gaussian noise for continuous variables. The default is 2.}

\item{censorRate}{The rate censored variables are censored at. The
default is 0.3.}

\item{seed}{The random seed for generating the simulated DAG. The
default is NULL.}
}
\value{
A list containing the simulated dataset and the
    corresponding ground truth causal DAG.
}
\description{
A function to simulate a random forward DAG from a SEM model.
}
\examples{
sim <- simRandomDAG(200, 25)
print(sim$graph)
print(sim$data[1:6,])
}
