% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prMetricsCausal}
\alias{prMetricsCausal}
\title{Causal Orientaion Precision-Recall Metrics for CPDAGs}
\usage{
prMetricsCausal(estimate, groundTruthDAG)
}
\arguments{
\item{estimate}{An estimated graph object.}

\item{groundTruthDAG}{A ground truth graph object of the type "directed acyclic graph".}
}
\value{
The causal orientation precision, recall, and F1 between the two graph objects
}
\description{
Calculate the causal orientation precision, recall, and F1 between an estimated CPDAG and ground truth graph causal DAG.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g <- pcStable(sim$data)
prMetricsCausal(g, sim$graph)
}
}
