% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prMetricsAdjacency}
\alias{prMetricsAdjacency}
\title{Adjacency Precision-Recall Metrics}
\usage{
prMetricsAdjacency(estimate, groundTruth)
}
\arguments{
\item{estimate}{An estimated graph object}

\item{groundTruth}{A ground truth graph object}
}
\value{
The skeleton precision, recall, F1, and MCC, between the two graph objects
}
\description{
Calculate the skeleton precision, recall, F1, and Matthew's Correlation Coefficient (MCC) between an estimated and ground truth graph.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g <- pcStable(sim$data)
prMetricsAdjacency(g, cpdag(sim$graph))
}
}
