% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prMetrics}
\alias{prMetrics}
\title{Combined adjaceny and orientation precision-recall metrics}
\usage{
prMetrics(estimate, groundTruth, groundTruthDAG = NULL)
}
\arguments{
\item{estimate}{An estimated graph object}

\item{groundTruth}{A ground truth graph object of the same type as the estimated graph object}

\item{groundTruthDAG}{A ground truth graph object containing the true causal DAG. Only necessary for calculating the or precision, recall, F1, and MCC for partial ancestral graphs (PAGs)}
}
\value{
The orientation precision, recall, F1, and MCC, between the two graph objects
}
\description{
Calculate the precision, recall, F1, and Matthew's Correlation Coefficient (MCC) for the adjacencies and orientations of an estimated graph compared to the ground truth. This is the concatenated output of the adjacency PR metrics and the orientation PR metrics.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g <- pcStable(sim$data)
prMetrics(g, cpdag(sim$graph))
}
}
