% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pcStars}
\alias{pcStars}
\title{Implements StARS for PC-Stable}
\usage{
pcStars(
  data,
  initialGraph = NULL,
  knowledge = NULL,
  orientRule = as.character(c("majority")),
  alphas = NULL,
  gamma = 0.01,
  numSub = 20L,
  subSize = -1L,
  leaveOneOut = FALSE,
  threads = -1L,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{initialGraph}{An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.}

\item{knowledge}{A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.}

\item{orientRule}{Determines which of the four possible orientation rules will be utilized to orient colliders in the PC-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority".}

\item{alphas}{A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).}

\item{gamma}{The threshold for edge instability. The default value is 0.01, and it is not recommended to change this value.}

\item{numSub}{The number of subsamples of the dataset used to estimate edge instability. The default value is 20.}

\item{subSize}{The number of samples to be drawn without replacement for each subsample. The default value is -1. When subSize is -1, it is set to min(floor(0.75 * N), floor(10*sqrt(N))), where N is the number of samples.}

\item{leaveOneOut}{If TRUE, performs leave-one-out subsampling. Defaults to FALSE.}

\item{threads}{An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphSTARS object containing the CPDAG selected by StARS and the instabilities at each value of alpha.
}
\description{
Runs StARS to select the value of alpha for PC-Stable based on adjacency stability. Returns a graphSTARS object containing the CPDAG selected by StARS and the adjacency instabilities for each alpha.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g.stars <- pcStars(sim$data)
print(g.stars)
}
}
