% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pcCV}
\alias{pcCV}
\title{Implements k-fold cross-validation for PC-Stable}
\usage{
pcCV(
  data,
  initialGraph = NULL,
  knowledge = NULL,
  orientRule = as.character(c("majority", "maxp", "conservative")),
  alphas = NULL,
  nfolds = 5L,
  foldid = NULL,
  threads = -1L,
  fdr = FALSE,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{initialGraph}{An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.}

\item{knowledge}{A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.}

\item{orientRule}{A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.}

\item{alphas}{A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).}

\item{nfolds}{An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.}

\item{foldid}{An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.}

\item{threads}{An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.}

\item{fdr}{A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphCV object containing the CPDAGs selected by the minimum and one standard error rule.
}
\description{
Runs k-fold cross-validation to select the value of alpha and orientation rule for PC-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g.cv <- pcCV(sim$data)
print(g.cv)
}
}
