% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pag}
\alias{pag}
\title{Calculate the PAG for a given DAG and set of latent variables}
\usage{
pag(graph, latent = NULL)
}
\arguments{
\item{graph}{The graph object used to generate the PAG. Should be the ground-truth causal DAG}

\item{latent}{The names of latent (unobserved) variables in the causal DAG. The default is NULL.}
}
\value{
The PAG corresponding to the input DAG
}
\description{
Create the partial ancestral graph (PAG) for the input directed acyclic graph (DAG). The PAG represents the Markov equivalence class of the true cauasl MAG. The FCI algorithms are only identifiable up to the Markov equivalence class, so assessments of causal structure recovery should be compared to the PAG rather than the causal MAG.
}
\examples{
sim <- simRandomDAG(200, 25, deg=2)
sim$pag <- pag(sim$graph)
print(sim$pag)
}
