% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{moral}
\alias{moral}
\title{Calculate the moral graph for a given DAG}
\usage{
moral(graph)
}
\arguments{
\item{graph}{The graph object used to generate the moral graph. Should be the ground-truth causal DAG}
}
\value{
The moral graph corresponding to the input DAG
}
\description{
Create the moral graph for the input directed acyclic graph (DAG). The moral graph is the undirected graphical model that is equivalent to the input DAG.
}
\examples{
sim <- simRandomDAG(200, 25, deg=2)
sim$moral <- moral(sim$graph)
print(sim$moral)
}
