% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mgmfciCV}
\alias{mgmfciCV}
\title{Implements k-fold cross-validation for MGM-FCI-Stable}
\usage{
mgmfciCV(
  data,
  knowledge = NULL,
  cvType = "random",
  orientRule = as.character(c("majority", "maxp", "conservative")),
  lambdas = NULL,
  nLambda = 20L,
  alphas = NULL,
  numPoints = 60L,
  nfolds = 5L,
  foldid = NULL,
  threads = -1L,
  fdr = FALSE,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{knowledge}{A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.}

\item{cvType}{A string determining whether to perform random search or grid search cross-validation, indicated by "random" or "grid" respectively. The default value is "random".}

\item{orientRule}{A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.}

\item{lambdas}{A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.}

\item{nLambda}{A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 20.}

\item{alphas}{A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).}

\item{numPoints}{An integer value containing indicating the number of samples to draw uniformly from the search space if performing random search cross-validation. The default is 60, the number of points required to have a 5\% chance of sampling a model in the top 5\% of the search space.}

\item{nfolds}{An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.}

\item{foldid}{An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.}

\item{threads}{An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.}

\item{fdr}{A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphCV object containing the PAGs selected by the minimum and one standard error rule.
}
\description{
Runs k-fold cross-validation to select the value of lambda, alpha, and the orientation rule for MGM-FCI-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g.cv <- mgmfciCV(sim$data)
print(g.cv)
}
}
