% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mgmPath}
\alias{mgmPath}
\title{Estimates a solution path for MGM}
\usage{
mgmPath(data, lambdas = NULL, nLambda = 30L, rank = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{lambdas}{A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.}

\item{nLambda}{A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphPath object that contains MGM graphs learned by the solution path, as well as the BIC and AIC selected models
}
\description{
Calculate the solution path for an MGM graph on a dataset. It also returns the models selected by the BIC and AIC scores.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
ig.path <- mgmPath(sim$data)
print(ig.path)
}
}
