% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mgmCV}
\alias{mgmCV}
\title{Implements k-fold cross-validation for MGM}
\usage{
mgmCV(
  data,
  lambdas = NULL,
  nLambda = 30L,
  nfolds = 5L,
  foldid = NULL,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{lambdas}{A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.}

\item{nLambda}{A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.}

\item{nfolds}{An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.}

\item{foldid}{An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graphCV object that contains the minimum and one standard error rule selected graphs.
}
\description{
Calculate the solution path for an MGM graph on a dataset with k-fold cross-validation. This function returns the graph that minimizes negative log(pseudolikelihood) and the graph selected by the one standard error rule.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
ig.cv <- mgmCV(sim$data)
print(ig.cv)
}
}
