% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mgm}
\alias{mgm}
\title{Calculate the Mixed Graphical Model (MGM) graph on a dataset.}
\usage{
mgm(data, lambda = as.numeric(c(0.2, 0.2, 0.2)), rank = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{lambda}{A numeric vector of three values for the regularization parameter lambda: the first for continuous-continuous edges, the second for continuous-discrete, and the third for discrete-discrete. Defaults to c(0.2, 0.2, 0.2). If a single value is provided, all three values in the vector will be set to that value.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print updates on the progress of optimizing MGM. The default is FALSE.}
}
\value{
The calculated MGM graph
}
\description{
Calculate the MGM graph on a dataset. The dataset may contain continuous and discrete variables. In the case that it contains only continuous variables, MGM reduces to a pseudo-likelihood estimate of the graphical LASSO, and in the case that it contains only discrete variables, MGM reduces to a pseudo-likelihood estimate of a pairwise Markov random field.
}
\examples{
sim <- simRandomDAG(200, 25, deg=2)
g <- mgm(sim$data)
print(g)
}
