% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{growShrinkMB}
\alias{growShrinkMB}
\title{Implements Grow-Shrink algorithm for Markov blanket identification}
\usage{
growShrinkMB(data, target, penalty = 1, rank = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{target}{A string denoting the name of the target variable to identify the Markov blanket of.}

\item{penalty}{A numeric value that represents the strength of the penalty for model complexity. The default value is 1, which corresponds to the BIC score.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
The list of features in the Markov Blanket and the BIC score
}
\description{
Runs the Grow-Shrink algorithm to find the Markov blanket of a feature in a dataset
}
\examples{
sim <- simRandomDAG(200, 25, deg=2)
mb <- growShrinkMB(sim$data, "X1")
print(mb)
}
