% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fciStable}
\alias{fciStable}
\title{Runs the causal discovery algorithm FCI-Stable on a dataset.}
\usage{
fciStable(
  data,
  initialGraph = NULL,
  knowledge = NULL,
  orientRule = as.character(c("majority")),
  alpha = 0.05,
  threads = -1L,
  possDsep = TRUE,
  fdr = FALSE,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{initialGraph}{An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.}

\item{knowledge}{A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.}

\item{orientRule}{Determines which of the four possible orientation rules will be utilized to orient colliders in the FCI-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority". Additionally, a vector of valid orientation rules can be provided, and fciStable will return a list containing the graphs learned with each.}

\item{alpha}{A numeric value containing the significance threshold alpha for the conditional independence tests used during constraint-based causal discovery. This parameter directly controls graph sparsity, with low values of alpha yielding sparse graphs and high values yielding dense graphs. The default value is 0.05.}

\item{threads}{An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.}

\item{possDsep}{A logical value indicating whether to perform the possible-D-Sep search stage of the FCI algorithm. The possible-D-Sep search is necessaey fro correctness but can be computationally expensive in dense or high-dimensional or graphs. If set to FALSE, the RFCI rule R0 will be applied to remove some of the extraneous adjacencies that would have been removed by possible-D-Sep search. The default value is TRUE.}

\item{fdr}{A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
The PAG learned by FCI-Stable.
}
\description{
Runs the causal discovery algorithm FCI-Stable on a dataset. The FCI-Stable algorithm is designed to recover the Markov equivalence class of causal MAGs that could give rise to the observed conditional independence relationships in the causally insufficient case. This means that FCI-Stable can still learn the Markov equivalence class of the true MAG even in the presence of latent confounders and/or selection bias. The resulting graph is a partial ancestral graph (PAG).
}
\examples{
\donttest{
sim <- simRandomDAG(200, 50, deg=3)
g <- fciStable(sim$data)
print(g)
}
}
