% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFunctions.R
\name{createKnowledge}
\alias{createKnowledge}
\title{A function to create a prior knowledge object for use with causal
discovery algorithms}
\usage{
createKnowledge(
  tiers = list(),
  forbiddenWithinTier = NULL,
  forbidden = list(),
  required = list()
)
}
\arguments{
\item{tiers}{A list containing ordered vectors of variables where
variables in tier t can only be ancestors of variables in tiers
t+1 ... T and descendants of variables in tiers (1 .. t-1). If
tiers are used, all variables must be in a tier, and no
variable can be in multiple tiers.}

\item{forbiddenWithinTier}{A vector of logical values indicating
whether edges are allowed between variables in a given
tier. The value is NULL by default, which results in
forbiddenWithinTier being set to FALSE for each tier.}

\item{forbidden}{A list containing vectors of node pairs that
forbid a specific directed edge. For example, to forbid 
A --> B, add c("A", "B") to forbidden.}

\item{required}{A list containing vectors of node pairs that
require the presence of a specific directed edge. For example,
to require B --> A, add c("B", "A") to required.}
}
\value{
A knowledge object that can be passed to causal discovery
    algorithms.
}
\description{
A function to create a prior knowledge object for use with causal
discovery algorithms
}
