% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{coxmgm}
\alias{coxmgm}
\title{Calculate the CoxMGM graph on a dataset.}
\usage{
coxmgm(
  data,
  lambda = as.numeric(c(0.2, 0.2, 0.2, 0.2, 0.2)),
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. All censored variables must be a survival::Surv object. Any rows with missing values will be dropped.}

\item{lambda}{A numeric vector of five values for the regularization parameter lambda: the first for continuous-continuous edges, the second for continuous-discrete, the third for discrete-discrete, the fourth for continuous-survival, and the fifth for discrete-survival. Defaults to c(0.2, 0.2, 0.2, 0.2, 0.2). If a single value is provided, all three values in the vector will be set to that value.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print updates on the progress of optimizing MGM. The default is FALSE.}
}
\value{
The calculated CoxMGM graph
}
\description{
Calculate the CoxMGM graph on a dataset. The dataset must contain at least one censored variable formatted as Surv object from the survival package.
}
\examples{
sim <- simRandomDAG(200, 25, 1)
ig <- coxmgm(sim$data)
print(ig)
}
