% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{boss}
\alias{boss}
\title{Runs the BOSS causal discovery algorithm on the dataset}
\usage{
boss(
  data,
  numStarts = 3L,
  penalty = 2,
  threads = -1L,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{numStarts}{The number of restarts (with different randomly sampled initial topological orders). Reduces the variance that can result from being stuck with an unfavorable initial starting order.}

\item{penalty}{A numeric value that represents the strength of the penalty for model complexity. The default value is 2, which corresponds to twice the BIC penalty.}

\item{threads}{An integer value denoting the number of threads to use for parallelization. The default value is -1, which will all available CPUs.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
The CPDAG learned by BOSS
}
\description{
Runs the BOSS causal discovery algorithm on the dataset
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g <- boss(sim$data)
print(g)
}
}
