% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bootstrap}
\alias{bootstrap}
\title{Runs bootstrapping for a causal graph on the dataset.}
\usage{
bootstrap(
  data,
  graph,
  knowledge = NULL,
  numBoots = 20L,
  threads = -1L,
  replace = FALSE,
  rank = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.}

\item{graph}{A graph object containing the graph to estimate the stability of through bootstrapping.}

\item{knowledge}{A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.}

\item{numBoots}{The number of bootstrap samples to run. The default is 20.}

\item{threads}{An integer value denoting the number of threads to use for parallelization. The default value is -1, which will all available CPUs.}

\item{replace}{A logical value indicating whether to use sampling with replacement or to draw subsamples of size floor(0.632 * N). The default value is FALSE.}

\item{rank}{A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.}

\item{verbose}{A logical value indicating whether to print progress updates. The default is FALSE.}
}
\value{
A graph object representing an ensemble graph learned from bootstrapped samples. For each adjacency observed across the bootstrap graphs, if absence is not the most frequent outcome, the edge orientation with the highest frequency is included in the ensemble graph. The object also contains a 'stabilities' data frame that records the frequencies of all possible edge orientations for each observed adjacency. The ensemble graph may not becorrespond to a valid CPDAG or PAG and is not guaranteed to represent a causal graph.
}
\description{
Runs bootstrapping for a causal graph on the dataset. This function can be used to estimate the stability of edge adjacencies and orientations in the causal graph. It returns an ensemble graph which consists of the most common edges accross bootstrap samples. The ensemble graph is constructed based on edge-wise probabilities, so it is not guaranteed to be a valid CPDAG or PAG. The ensemble graph's stabilites entry contains information about the frequency of each possible orientation for each edge that appears at least once across bootstrap samples.
}
\examples{
\donttest{
sim <- simRandomDAG(200, 25, deg=2)
g <- pcStable(sim$data)
g.boot <- bootstrap(sim$data, g)
print(g.boot)
print(g.boot$stabilities[1:6,])
}
}
