% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{adjMat2Graph}
\alias{adjMat2Graph}
\title{Convert an adjacency matrix into a graph}
\usage{
adjMat2Graph(adj, nodes, directed = FALSE)
}
\arguments{
\item{adj}{The adjacency matrix, p x p, with non-zero values indicating the presence of an adjacency.}

\item{nodes}{The names of the nodes, length p.}

\item{directed}{TRUE if the graph should be directed. This default is  FALSE.}
}
\value{
A graph object representing the adjacency matrix.
}
\description{
Convert an adjacency matrix into a graph
}
\examples{
mat <- matrix(sample(c(0,1), 16, replace=TRUE), nrow=4)
mat <- mat + t(mat)
nodes <- c("X1", "X2", "X3", "X4")
g <- adjMat2Graph(mat, nodes)
}
