# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Save a graph to a file. Supported file types are ".txt" and ".sif". 
#'
#' @param graph The graph object
#' @param filename The graph filename
#' @return No return value. This function saves the full details of a graph object to a .txt file, including nodes, edges, the algorithm used to learn the model, and relevant hyperparameters. This format can then be read back into R with the loadGraph function.
#' @export
saveGraph <- function(graph, filename) {
    invisible(.Call(`_rCausalMGM_saveGraph`, graph, filename))
}

#' Load a graph from a ".txt" file
#'
#' @param filename The graph file
#' @return The graph as a graph object, which can be passed into search functions
#' @export
loadGraph <- function(filename) {
    .Call(`_rCausalMGM_loadGraph`, filename)
}

#' Convert an adjacency matrix into a graph
#'
#' @param adj The adjacency matrix, p x p, with non-zero values indicating the presence of an adjacency.
#' @param nodes The names of the nodes, length p.
#' @param directed TRUE if the graph should be directed. This default is  FALSE.
#' @return A graph object representing the adjacency matrix.
#' @export
#' @examples
#' mat <- matrix(sample(c(0,1), 16, replace=TRUE), nrow=4)
#' mat <- mat + t(mat)
#' nodes <- c("X1", "X2", "X3", "X4")
#' g <- adjMat2Graph(mat, nodes)
adjMat2Graph <- function(adj, nodes, directed = FALSE) {
    .Call(`_rCausalMGM_adjMat2Graph`, adj, nodes, directed)
}

#' Display a graph object as text.
#'
#' @description Display a graph object as text. This is the same format as written in ".txt" save files.
#'
#' @param graph The graph object
#' @return No return value, this function prints the full details of a graph object, including nodes, edges, the algorithm used to learn the model, and relevant hyperparameters.
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- mgm(sim$data)
#' printGraph(g)
printGraph <- function(graph) {
    invisible(.Call(`_rCausalMGM_printGraph`, graph))
}

#' Calculate the CPDAG for a given DAG
#'
#' @description Create the completed partially directed acyclic graph (CPDAG) for the input directed acyclic graph (DAG). The CPDAG represents the Markov equivalence class of the true cauasl DAG. The PC algorithms are only identifiable up to the Markov equivalence class, so assessments of causal structure recovery should be compared to the CPDAG rather than the causal DAG.
#'
#' @param graph The graph object used to generate the CPDAG. Should be the ground-truth causal DAG
#' @return The CPDAG corresponding to the input DAG
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' sim$cpdag <- cpdag(sim$graph)
#' print(sim$cpdag)
cpdag <- function(graph) {
    .Call(`_rCausalMGM_cpdag`, graph)
}

#' Calculate the moral graph for a given DAG
#'
#' @description Create the moral graph for the input directed acyclic graph (DAG). The moral graph is the undirected graphical model that is equivalent to the input DAG.
#'
#' @param graph The graph object used to generate the moral graph. Should be the ground-truth causal DAG
#' @return The moral graph corresponding to the input DAG
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' sim$moral <- moral(sim$graph)
#' print(sim$moral)
moral <- function(graph) {
    .Call(`_rCausalMGM_moral`, graph)
}

#' Calculate the undirected skeleton for a given DAG
#'
#' @description Create the skeleton graph for the input directed acyclic graph (DAG). The skeleton graph is the undirected graph that contains the same adjacencies as the input DAG.
#'
#' @param graph The graph object used to generate the skeleton graph. Should be the ground-truth causal DAG
#' @return The skeleton graph corresponding to the input DAG
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' sim$skeleton <- skeleton(sim$graph)
#' print(sim$skeleton)
skeleton <- function(graph) {
    .Call(`_rCausalMGM_skeleton`, graph)
}

#' Calculate the PAG for a given DAG and set of latent variables
#'
#' @description Create the partial ancestral graph (PAG) for the input directed acyclic graph (DAG). The PAG represents the Markov equivalence class of the true cauasl MAG. The FCI algorithms are only identifiable up to the Markov equivalence class, so assessments of causal structure recovery should be compared to the PAG rather than the causal MAG.
#'
#' @param graph The graph object used to generate the PAG. Should be the ground-truth causal DAG
#' @param latent The names of latent (unobserved) variables in the causal DAG. The default is NULL.
#' @return The PAG corresponding to the input DAG
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' sim$pag <- pag(sim$graph)
#' print(sim$pag)
pag <- function(graph, latent = NULL) {
    .Call(`_rCausalMGM_pag`, graph, latent)
}

#' Structural Hamming Distance (SHD)
#'
#' @description Calculate the Structural Hamming Distance (SHD) between two graphs.
#'
#' @param graph1 A graph object
#' @param graph2 A graph object
#' @return The SHD btween the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' SHD(g, cpdag(sim$graph))
#' }
SHD <- function(graph1, graph2) {
    .Call(`_rCausalMGM_SHD`, graph1, graph2)
}

#' Adjacency Precision-Recall Metrics
#'
#' @description Calculate the skeleton precision, recall, F1, and Matthew's Correlation Coefficient (MCC) between an estimated and ground truth graph.
#'
#' @param estimate An estimated graph object
#' @param groundTruth A ground truth graph object
#' @return The skeleton precision, recall, F1, and MCC, between the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' prMetricsAdjacency(g, cpdag(sim$graph))
#' }
prMetricsAdjacency <- function(estimate, groundTruth) {
    .Call(`_rCausalMGM_prMetricsAdjacency`, estimate, groundTruth)
}

#' Orientation Precision-Recall Metrics
#'
#' @description Calculate the orientation precision, recall, F1, and Matthew's Correlation Coefficient (MCC) between an estimated and ground truth graph.
#'
#' @param estimate An estimated graph object
#' @param groundTruth A ground truth graph object of the same type as the estimated graph object
#' @param groundTruthDAG A ground truth graph object containing the true causal DAG. Only necessary for calculating the or precision, recall, F1, and MCC for partial ancestral graphs (PAGs)
#' @return The orientation precision, recall, F1, and MCC, between the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' prMetricsOrientation(g, cpdag(sim$graph))
#' }
prMetricsOrientation <- function(estimate, groundTruth, groundTruthDAG = NULL) {
    .Call(`_rCausalMGM_prMetricsOrientation`, estimate, groundTruth, groundTruthDAG)
}

#' Causal Orientaion Precision-Recall Metrics for CPDAGs
#'
#' @description Calculate the causal orientation precision, recall, and F1 between an estimated CPDAG and ground truth graph causal DAG.
#'
#' @param estimate An estimated graph object.
#' @param groundTruthDAG A ground truth graph object of the type "directed acyclic graph".
#' @return The causal orientation precision, recall, and F1 between the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' prMetricsCausal(g, sim$graph)
#' }
prMetricsCausal <- function(estimate, groundTruthDAG) {
    .Call(`_rCausalMGM_prMetricsCausal`, estimate, groundTruthDAG)
}

#' Combined adjaceny and orientation precision-recall metrics
#'
#' @description Calculate the precision, recall, F1, and Matthew's Correlation Coefficient (MCC) for the adjacencies and orientations of an estimated graph compared to the ground truth. This is the concatenated output of the adjacency PR metrics and the orientation PR metrics.
#' @param estimate An estimated graph object
#' @param groundTruth A ground truth graph object of the same type as the estimated graph object
#' @param groundTruthDAG A ground truth graph object containing the true causal DAG. Only necessary for calculating the or precision, recall, F1, and MCC for partial ancestral graphs (PAGs)
#' @return The orientation precision, recall, F1, and MCC, between the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' prMetrics(g, cpdag(sim$graph))
#' }
prMetrics <- function(estimate, groundTruth, groundTruthDAG = NULL) {
    .Call(`_rCausalMGM_prMetrics`, estimate, groundTruth, groundTruthDAG)
}

#' Combined graph recovery metrics
#'
#' @description Calculate the SHD, precision, recall, F1, and Matthew's Correlation Coefficient (MCC) for the adjacencies and orientations of an estimated graph compared to the ground truth. This is the concatenated output of the SHD, adjacency PR metrics, and the orientation PR metrics.
#' @param estimate An estimated graph object
#' @param groundTruth A ground truth graph object of the same type as the estimated graph object
#' @param groundTruthDAG A ground truth graph object containing the true causal DAG. Only necessary for calculating the or precision, recall, F1, and MCC for partial ancestral graphs (PAGs)
#' @return The orientation precision, recall, F1, and MCC, between the two graph objects
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' allMetrics(g, cpdag(sim$graph))
#' }
allMetrics <- function(estimate, groundTruth, groundTruthDAG = NULL) {
    .Call(`_rCausalMGM_allMetrics`, estimate, groundTruth, groundTruthDAG)
}

#' Calculate the Mixed Graphical Model (MGM) graph on a dataset.
#'
#' @description Calculate the MGM graph on a dataset. The dataset may contain continuous and discrete variables. In the case that it contains only continuous variables, MGM reduces to a pseudo-likelihood estimate of the graphical LASSO, and in the case that it contains only discrete variables, MGM reduces to a pseudo-likelihood estimate of a pairwise Markov random field.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param lambda A numeric vector of three values for the regularization parameter lambda: the first for continuous-continuous edges, the second for continuous-discrete, and the third for discrete-discrete. Defaults to c(0.2, 0.2, 0.2). If a single value is provided, all three values in the vector will be set to that value.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print updates on the progress of optimizing MGM. The default is FALSE.
#' @return The calculated MGM graph
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- mgm(sim$data)
#' print(g)
mgm <- function(data, lambda = as.numeric( c(0.2, 0.2, 0.2)), rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_mgm`, data, lambda, rank, verbose)
}

#' Calculate the CoxMGM graph on a dataset.
#'
#' @description Calculate the CoxMGM graph on a dataset. The dataset must contain at least one censored variable formatted as Surv object from the survival package.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. All censored variables must be a survival::Surv object. Any rows with missing values will be dropped.
#' @param lambda A numeric vector of five values for the regularization parameter lambda: the first for continuous-continuous edges, the second for continuous-discrete, the third for discrete-discrete, the fourth for continuous-survival, and the fifth for discrete-survival. Defaults to c(0.2, 0.2, 0.2, 0.2, 0.2). If a single value is provided, all three values in the vector will be set to that value.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print updates on the progress of optimizing MGM. The default is FALSE.
#' @return The calculated CoxMGM graph
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, 1)
#' ig <- coxmgm(sim$data)
#' print(ig)
coxmgm <- function(data, lambda = as.numeric( c(0.2, 0.2, 0.2, 0.2, 0.2)), rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_coxmgm`, data, lambda, rank, verbose)
}

#' Estimates a solution path for MGM
#'
#' @description Calculate the solution path for an MGM graph on a dataset. It also returns the models selected by the BIC and AIC scores.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphPath object that contains MGM graphs learned by the solution path, as well as the BIC and AIC selected models
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' ig.path <- mgmPath(sim$data)
#' print(ig.path)
#' }
mgmPath <- function(data, lambdas = NULL, nLambda = 30L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_mgmPath`, data, lambdas, nLambda, rank, verbose)
}

#' Estimates a solution path for CoxMGM
#'
#' @description Calculate the solution path for a CoxMGM graph on a dataset. The dataset must contain at least one censored variable formatted as Surv object from the survival package. It also returns the models selected by the BIC and AIC scores.
#'
#' @param data A data.frame containing the dataset to be used for estimating the CoxMGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. All censored variables must be a survival::Surv object. Any rows with missing values will be dropped.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphPath object that contains CoxMGM graphs learned by the solution path, as well as the BIC and AIC selected models
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, 1)
#' ig.path <- coxmgmPath(sim$data)
#' print(ig.path)
#' }
coxmgmPath <- function(data, lambdas = NULL, nLambda = 30L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_coxmgmPath`, data, lambdas, nLambda, rank, verbose)
}

#' Implements k-fold cross-validation for MGM
#'
#' @description Calculate the solution path for an MGM graph on a dataset with k-fold cross-validation. This function returns the graph that minimizes negative log(pseudolikelihood) and the graph selected by the one standard error rule.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object that contains the minimum and one standard error rule selected graphs.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' ig.cv <- mgmCV(sim$data)
#' print(ig.cv)
#' }
mgmCV <- function(data, lambdas = NULL, nLambda = 30L, nfolds = 5L, foldid = NULL, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_mgmCV`, data, lambdas, nLambda, nfolds, foldid, rank, verbose)
}

#' Implements k-fold cross-validation for CoxMGM
#'
#' @description Calculate the solution path for a CoxMGM graph on a dataset with k-fold cross-validation. The dataset must contain at least one censored variable formatted as Surv object from the survival package. This function returns the graph that minimizes negative log(pseudolikelihood) and the graph selected by the one standard error rule.
#'
#' @param data A data.frame containing the dataset to be used for estimating the CoxMGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. All censored variables must be a survival::Surv object. Any rows with missing values will be dropped.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object that contains the minimum and one standard error rule selected graphs.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, 1)
#' ig.cv <- coxmgmCV(sim$data)
#' print(ig.cv)
#' }
coxmgmCV <- function(data, lambdas = NULL, nLambda = 30L, nfolds = 5L, foldid = NULL, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_coxmgmCV`, data, lambdas, nLambda, nfolds, foldid, rank, verbose)
}

#' Implements StEPS and StARS for MGM
#'
#' @description Calculates the optimal lambda values for the MGM algorithm using StEPS and StARS. Returns a graphSTEPS object that contains the MGMs selected by StEPS and StARS as well as the instability at each value of lambda.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 30.
#' @param gamma The threshold for edge instability. The default value is 0.05, and it is not recommended to change this value.
#' @param numSub The number of subsamples of the dataset used to estimate edge instability. The default value is 20.
#' @param subSize The number of samples to be drawn without replacement for each subsample. The default value is -1. When subSize is -1, it is set to min(floor(0.75 * N), floor(10*sqrt(N))), where N is the number of samples.
#' @param leaveOneOut If TRUE, performs leave-one-out subsampling. Defaults to FALSE.
#' @param threads An integer value denoting the number of threads to use for parallelization of learning MGMs across subsamples. The default value is -1, which will all available CPUs.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphSTEPS object containing the MGMs selected by StEPS and StARS, as well as the instability of each edge type at each value of lambda.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' ig.steps <- steps(sim$data)
#' print(ig.steps)
#' }
steps <- function(data, lambdas = NULL, nLambda = 30L, gamma = 0.05, numSub = 20L, subSize = -1L, leaveOneOut = FALSE, threads = -1L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_steps`, data, lambdas, nLambda, gamma, numSub, subSize, leaveOneOut, threads, rank, verbose)
}

#' Implements StARS for PC-Stable
#'
#' @description Runs StARS to select the value of alpha for PC-Stable based on adjacency stability. Returns a graphSTARS object containing the CPDAG selected by StARS and the adjacency instabilities for each alpha.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule Determines which of the four possible orientation rules will be utilized to orient colliders in the PC-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority". 
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param gamma The threshold for edge instability. The default value is 0.01, and it is not recommended to change this value.
#' @param numSub The number of subsamples of the dataset used to estimate edge instability. The default value is 20.
#' @param subSize The number of samples to be drawn without replacement for each subsample. The default value is -1. When subSize is -1, it is set to min(floor(0.75 * N), floor(10*sqrt(N))), where N is the number of samples.
#' @param leaveOneOut If TRUE, performs leave-one-out subsampling. Defaults to FALSE.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphSTARS object containing the CPDAG selected by StARS and the instabilities at each value of alpha.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.stars <- pcStars(sim$data)
#' print(g.stars)
#' }
pcStars <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority")), alphas = NULL, gamma = 0.01, numSub = 20L, subSize = -1L, leaveOneOut = FALSE, threads = -1L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_pcStars`, data, initialGraph, knowledge, orientRule, alphas, gamma, numSub, subSize, leaveOneOut, threads, rank, verbose)
}

#' Implements StARS for FCI-Stable
#'
#' @description Runs StARS to select the value of alpha for FCI-Stable based on adjacency stability. Returns a graphSTARS object containing the PAG selected by StARS and the adjacency instabilities for each alpha.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule Determines which of the four possible orientation rules will be utilized to orient colliders in the FCI-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority". 
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param gamma The threshold for edge instability. The default value is 0.01, and it is not recommended to change this value.
#' @param numSub The number of subsamples of the dataset used to estimate edge instability. The default value is 20.
#' @param subSize The number of samples to be drawn without replacement for each subsample. The default value is -1. When subSize is -1, it is set to min(floor(0.75 * N), floor(10*sqrt(N))), where N is the number of samples.
#' @param leaveOneOut If TRUE, performs leave-one-out subsampling. Defaults to FALSE.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphSTARS object containing the PAG selected by StARS and the instabilities at each value of alpha.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.stars <- fciStars(sim$data)
#' print(g.stars)
#' }
fciStars <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority")), alphas = NULL, gamma = 0.01, numSub = 20L, subSize = -1L, leaveOneOut = FALSE, threads = -1L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_fciStars`, data, initialGraph, knowledge, orientRule, alphas, gamma, numSub, subSize, leaveOneOut, threads, rank, verbose)
}

#' Runs the causal discovery algorithm PC-Stable on a dataset.
#'
#' @description Runs the causal discovery algorithm PC-Stable on a dataset. The PC-Stable algorithm is designed to recover the Markov equivalence class of causal DAGs that could give rise to the observed conditional independence relationships under the assumption of causal sufficiency. A dataset is said to be causally sufficient if all variables relevant to the causal process are observed (i.e. there are no latent confounders). The resulting graph is a completed partially directed acyclic graph (CPDAG) containing directed edges where the causal orientation can be uniquely determined and an undirected edge where multiple orientations are possible.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule Determines which of the four possible orientation rules will be utilized to orient colliders in the PC-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority". Additionally, a vector of valid orientation rules can be provided, and pcStable will return a list containing the graphs learned with each.
#' @param alpha A numeric value containing the significance threshold alpha for the conditional independence tests used during constraint-based causal discovery. This parameter directly controls graph sparsity, with low values of alpha yielding sparse graphs and high values yielding dense graphs. The default value is 0.05.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return The CPDAG learned by PC-Stable.
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' print(g)
pcStable <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority")), alpha = 0.05, threads = -1L, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_pcStable`, data, initialGraph, knowledge, orientRule, alpha, threads, fdr, rank, verbose)
}

#' Runs the causal discovery algorithm FCI-Stable on a dataset.
#'
#' @description Runs the causal discovery algorithm FCI-Stable on a dataset. The FCI-Stable algorithm is designed to recover the Markov equivalence class of causal MAGs that could give rise to the observed conditional independence relationships in the causally insufficient case. This means that FCI-Stable can still learn the Markov equivalence class of the true MAG even in the presence of latent confounders and/or selection bias. The resulting graph is a partial ancestral graph (PAG).
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule Determines which of the four possible orientation rules will be utilized to orient colliders in the FCI-Stable algorithm. Possible options are "majority", "maxp", "conservative", and "sepsets". The default value is "majority". Additionally, a vector of valid orientation rules can be provided, and fciStable will return a list containing the graphs learned with each.
#' @param alpha A numeric value containing the significance threshold alpha for the conditional independence tests used during constraint-based causal discovery. This parameter directly controls graph sparsity, with low values of alpha yielding sparse graphs and high values yielding dense graphs. The default value is 0.05.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param possDsep A logical value indicating whether to perform the possible-D-Sep search stage of the FCI algorithm. The possible-D-Sep search is necessaey fro correctness but can be computationally expensive in dense or high-dimensional or graphs. If set to FALSE, the RFCI rule R0 will be applied to remove some of the extraneous adjacencies that would have been removed by possible-D-Sep search. The default value is TRUE.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return The PAG learned by FCI-Stable.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 50, deg=3)
#' g <- fciStable(sim$data)
#' print(g)
#' }
fciStable <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority")), alpha = 0.05, threads = -1L, possDsep = TRUE, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_fciStable`, data, initialGraph, knowledge, orientRule, alpha, threads, possDsep, fdr, rank, verbose)
}

#' Implements k-fold cross-validation for PC-Stable
#'
#' @description Runs k-fold cross-validation to select the value of alpha and orientation rule for PC-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object containing the CPDAGs selected by the minimum and one standard error rule.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.cv <- pcCV(sim$data)
#' print(g.cv)
#' }
pcCV <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority", "maxp", "conservative")), alphas = NULL, nfolds = 5L, foldid = NULL, threads = -1L, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_pcCV`, data, initialGraph, knowledge, orientRule, alphas, nfolds, foldid, threads, fdr, rank, verbose)
}

#' Implements k-fold cross-validation for FCI-Stable
#'
#' @description Runs k-fold cross-validation to select the value of alpha and orientation rule for FCI-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param initialGraph An undirected rCausalMGM graph object containing the initial skeleton of adjacencies used in the causal discovery algorithm. This graph can be learned by `mgm` or learned by another method and imported into an undirected rCausalMGM graph object from its adjacency matrix. The default is NULL, in which case a fully connected graph is used as the initial skeleton.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param orientRule A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object containing the PAGs selected by the minimum and one standard error rule.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.cv <- fciCV(sim$data)
#' print(g.cv)
#' }
fciCV <- function(data, initialGraph = NULL, knowledge = NULL, orientRule = as.character( c("majority", "maxp", "conservative")), alphas = NULL, nfolds = 5L, foldid = NULL, threads = -1L, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_fciCV`, data, initialGraph, knowledge, orientRule, alphas, nfolds, foldid, threads, fdr, rank, verbose)
}

#' Implements k-fold cross-validation for MGM-PC-Stable
#'
#' @description Runs k-fold cross-validation to select the value of lambda, alpha, and the orientation rule for MGM-PC-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param cvType A string determining whether to perform random search or grid search cross-validation, indicated by "random" or "grid" respectively. The default value is "random".
#' @param orientRule A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 20.
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param numPoints An integer value containing indicating the number of samples to draw uniformly from the search space if performing random search cross-validation. The default is 60, the number of points required to have a 5\% chance of sampling a model in the top 5\% of the search space.
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object containing the CPDAGs selected by the minimum and one standard error rule.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.cv <- mgmpcCV(sim$data)
#' print(g.cv)
#' }
mgmpcCV <- function(data, knowledge = NULL, cvType = "random", orientRule = as.character( c("majority", "maxp", "conservative")), lambdas = NULL, nLambda = 20L, alphas = NULL, numPoints = 60L, nfolds = 5L, foldid = NULL, threads = -1L, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_mgmpcCV`, data, knowledge, cvType, orientRule, lambdas, nLambda, alphas, numPoints, nfolds, foldid, threads, fdr, rank, verbose)
}

#' Implements k-fold cross-validation for MGM-FCI-Stable
#'
#' @description Runs k-fold cross-validation to select the value of lambda, alpha, and the orientation rule for MGM-FCI-Stable. Returns a graphCV object containing the causal graphical models that minimize the negative log(pseudo-likelihood) and the sparsest model within one standard error of the minimum.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param cvType A string determining whether to perform random search or grid search cross-validation, indicated by "random" or "grid" respectively. The default value is "random".
#' @param orientRule A vector of strings to determine which of the orientation rules to test in the cross-validation procedure to select the optimal model. The default is a vector that contains the "majority", "maxp", and "conservative" orientation rules.
#' @param lambdas A numeric vector containing the values of lambda to learn an MGM with. The default value is NULL, in which case a log-spaced vector of nLambda values for lambda will be supplied instead.
#' @param nLambda A numeric value indicating the number of lambda values to test when the lambdas vector is NULL. The default is 20.
#' @param alphas A numeric vector containing values of alpha to test in the cross-validation procedure. The default value is NULL, in which case we set alpha = c(0.001, 0.005, 0.01, 0.05, 0.1, 0.15, 0.2).
#' @param numPoints An integer value containing indicating the number of samples to draw uniformly from the search space if performing random search cross-validation. The default is 60, the number of points required to have a 5\% chance of sampling a model in the top 5\% of the search space.
#' @param nfolds An integer value defining the number of folds to be used for cross-validation if foldid is NULL. The default value is 5.
#' @param foldid An integer vector containing values in the range of 1 to K for each sample that identifies which test set that sample belongs to. This enables users to define their own cross-validation splits, for example in the case stratified cross-validation is needed. The default value is NULL.
#' @param threads An integer value denoting the number of threads to use for parallelization of independence tests. The default value is -1, which will all available CPUs.
#' @param fdr A logical value indicating whether to use false discovery rate control for the discovery of adjacencies in the causal graph. The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graphCV object containing the PAGs selected by the minimum and one standard error rule.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g.cv <- mgmfciCV(sim$data)
#' print(g.cv)
#' }
mgmfciCV <- function(data, knowledge = NULL, cvType = "random", orientRule = as.character( c("majority", "maxp", "conservative")), lambdas = NULL, nLambda = 20L, alphas = NULL, numPoints = 60L, nfolds = 5L, foldid = NULL, threads = -1L, fdr = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_mgmfciCV`, data, knowledge, cvType, orientRule, lambdas, nLambda, alphas, numPoints, nfolds, foldid, threads, fdr, rank, verbose)
}

#' Runs bootstrapping for a causal graph on the dataset.
#'
#' @description Runs bootstrapping for a causal graph on the dataset. This function can be used to estimate the stability of edge adjacencies and orientations in the causal graph. It returns an ensemble graph which consists of the most common edges accross bootstrap samples. The ensemble graph is constructed based on edge-wise probabilities, so it is not guaranteed to be a valid CPDAG or PAG. The ensemble graph's stabilites entry contains information about the frequency of each possible orientation for each edge that appears at least once across bootstrap samples.
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param graph A graph object containing the graph to estimate the stability of through bootstrapping.
#' @param knowledge A knowledge object containing prior knowledge about the causal interactions in a dataset. This knowledge can be used to forbid or require certain edges in the causal graph, helping to inform causal discovery an prevent orientations known to be nonsensical. The default is NULL, in which case no prior knowledge is provided to the causal discovery algorithm.
#' @param numBoots The number of bootstrap samples to run. The default is 20.
#' @param threads An integer value denoting the number of threads to use for parallelization. The default value is -1, which will all available CPUs.
#' @param replace A logical value indicating whether to use sampling with replacement or to draw subsamples of size floor(0.632 * N). The default value is FALSE.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return A graph object representing an ensemble graph learned from bootstrapped samples. For each adjacency observed across the bootstrap graphs, if absence is not the most frequent outcome, the edge orientation with the highest frequency is included in the ensemble graph. The object also contains a 'stabilities' data frame that records the frequencies of all possible edge orientations for each observed adjacency. The ensemble graph may not becorrespond to a valid CPDAG or PAG and is not guaranteed to represent a causal graph.
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- pcStable(sim$data)
#' g.boot <- bootstrap(sim$data, g)
#' print(g.boot)
#' print(g.boot$stabilities[1:6,])
#' }
bootstrap <- function(data, graph, knowledge = NULL, numBoots = 20L, threads = -1L, replace = FALSE, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_bootstrap`, data, graph, knowledge, numBoots, threads, replace, rank, verbose)
}

#' Implements Grow-Shrink algorithm for Markov blanket identification
#'
#' @description Runs the Grow-Shrink algorithm to find the Markov blanket of a feature in a dataset
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param target A string denoting the name of the target variable to identify the Markov blanket of.
#' @param penalty A numeric value that represents the strength of the penalty for model complexity. The default value is 1, which corresponds to the BIC score.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return The list of features in the Markov Blanket and the BIC score
#' @export
#' @examples
#' sim <- simRandomDAG(200, 25, deg=2)
#' mb <- growShrinkMB(sim$data, "X1")
#' print(mb)
growShrinkMB <- function(data, target, penalty = 1, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_growShrinkMB`, data, target, penalty, rank, verbose)
}

#' Runs the GRaSP causal discovery algorithm on the dataset 
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param depth The maximum search depth used in the depth-first search in GRaSP.
#' @param numStarts The number of restarts (with different randomly sampled initial topological orders). Reduces the variance that can result from being stuck with an unfavorable initial starting order.
#' @param penalty A numeric value that represents the strength of the penalty for model complexity. The default value is 2, which corresponds to twice the BIC penalty.
#' @param bossInit A logical value indicating whether to initialize the causal order for GRaSP with the forward search procedure of BOSS.
#' @param threads An integer value denoting the number of threads to use for parallelization. The default value is -1, which will all available CPUs.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return The CPDAG learned by GRaSP
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- grasp(sim$data)
#' print(g)
#' }
grasp <- function(data, depth = 2L, numStarts = 3L, penalty = 2, bossInit = FALSE, threads = -1L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_grasp`, data, depth, numStarts, penalty, bossInit, threads, rank, verbose)
}

#' Runs the BOSS causal discovery algorithm on the dataset 
#'
#' @param data A data.frame containing the dataset to be used for estimating the MGM, with each row representing a sample and each column representing a variable. All continuous variables must be of the numeric type, while categorical variables must be factor or character. Any rows with missing values will be dropped.
#' @param numStarts The number of restarts (with different randomly sampled initial topological orders). Reduces the variance that can result from being stuck with an unfavorable initial starting order.
#' @param penalty A numeric value that represents the strength of the penalty for model complexity. The default value is 2, which corresponds to twice the BIC penalty.
#' @param threads An integer value denoting the number of threads to use for parallelization. The default value is -1, which will all available CPUs.
#' @param rank A logical value indicating whether to use the nonparanormal transform to learn rank-based associations. The default is FALSE.
#' @param verbose A logical value indicating whether to print progress updates. The default is FALSE.
#' @return The CPDAG learned by BOSS
#' @export
#' @examples
#' \donttest{
#' sim <- simRandomDAG(200, 25, deg=2)
#' g <- boss(sim$data)
#' print(g)
#' }
boss <- function(data, numStarts = 3L, penalty = 2, threads = -1L, rank = FALSE, verbose = FALSE) {
    .Call(`_rCausalMGM_boss`, data, numStarts, penalty, threads, rank, verbose)
}

