% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_amGauge.R
\name{amSolidGauge}
\alias{amSolidGauge}
\title{Plotting solid gauge using rAmCharts}
\usage{
amSolidGauge(
  x,
  min = 0,
  max = 100,
  type = "full",
  width = 20,
  color = "",
  text = "",
  textSize = 20,
  ...
)
}
\arguments{
\item{x}{\code{numeric}, value for which the angular gauge is desired.}

\item{min}{\code{numeric}, minimal possible value.}

\item{max}{\code{numeric}, maximal possible value.}

\item{type}{\code{character}, type of gauge : "full" or "semi".}

\item{width}{\code{numeric}, width of the gauge.}

\item{color}{\code{character}, hexadecimal color value or a vector of colors.}

\item{text}{\code{character}, text.}

\item{textSize}{\code{numeric}, text size.}

\item{...}{see \code{\link{amOptions}} for more options.}
}
\description{
amSolidGauge computes a gauge of the given value.
}
\examples{
amSolidGauge(x = 65)

\dontrun{
# Other examples available which can be time consuming depending on your configuration.

if (requireNamespace("pipeR", quietly = TRUE)) {
require(pipeR)

# Change min and max values
amSolidGauge(x = 65, min = 0, max = 200)

# Semi solid gauge
amSolidGauge(x = 65, type = "semi")

# Change width
amSolidGauge(x = 65, width = 50)

# Change color
amSolidGauge(x = 65, color = "#2F4F4F")

# Put a color scale
amSolidGauge(x = 10, color = c("#00ff00", "#ffd700", "#ff0000"))
amSolidGauge(x = 35, color = c("#00ff00", "#ffd700", "#ff0000"))
amSolidGauge(x = 70, color = c("#00ff00", "#ffd700", "#ff0000"))
amSolidGauge(x = 90, color = c("#00ff00", "#ffd700", "#ff0000"))

# Add some text to the printed value
amSolidGauge(x = 65, text = "Pct")

# Modify textSize value
amSolidGauge(x = 65, text = "Pct", textSize = 50)
}
}

}
\references{
See online documentation \url{https://datastorm-open.github.io/introduction_ramcharts/}
and \link{amChartsAPI}
}
\seealso{
\link{amOptions}, \link{amBarplot}, \link{amBoxplot}, \link{amHist}, \link{amPie},
\link{amPlot}, \link{amTimeSeries}, \link{amStockMultiSet}, \link{amBullet}, \link{amRadar}, 
\link{amWind}, \link{amFunnel}, \link{amAngularGauge}, \link{amSolidGauge}, \link{amMekko},
\link{amCandlestick}, \link{amFloatingBar}, \link{amOHLC}, \link{amWaterfall}
}
