% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_evidence.R
\name{risk_register_to_evidence}
\alias{risk_register_to_evidence}
\title{Convert Risk Register to R4SUB Evidence}
\usage{
risk_register_to_evidence(
  risk_register,
  ctx,
  source_name = "r4subrisk",
  source_version = NULL
)
}
\arguments{
\item{risk_register}{A \code{risk_register} from \code{\link[=create_risk_register]{create_risk_register()}}.}

\item{ctx}{An \code{r4sub_run_context} from \code{r4subcore::r4sub_run_context()}.}

\item{source_name}{Character; the name of the evidence source.}

\item{source_version}{Character or \code{NULL}; version of the source.}
}
\value{
A data.frame of evidence rows passing \code{r4subcore::validate_evidence()}.
}
\description{
Emits evidence rows compatible with \code{r4subcore::validate_evidence()} for
each risk item in the register, plus aggregate risk metric rows.
}
\examples{
\donttest{
library(r4subcore)
ctx <- r4sub_run_context(study_id = "TEST001", environment = "DEV")
risks <- data.frame(
  risk_id = "R001", description = "Missing vars",
  probability = 4, impact = 5, detectability = 2
)
rr <- create_risk_register(risks)
ev <- risk_register_to_evidence(rr, ctx = ctx)
}

}
