% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_indicators.R
\name{risk_indicator_summary}
\alias{risk_indicator_summary}
\title{Compute Risk Indicator Summary}
\usage{
risk_indicator_summary(risk_register)
}
\arguments{
\item{risk_register}{A \code{risk_register} from \code{\link[=create_risk_register]{create_risk_register()}}.}
}
\value{
A tibble with columns: \code{indicator}, \code{value}, \code{description}.
}
\description{
Computes summary risk indicators from a risk register, similar to
\code{r4subtrace::trace_indicator_scores()}.
}
\examples{
risks <- data.frame(
  risk_id = c("R001", "R002", "R003"),
  description = c("Missing vars", "Bad derivation", "Label mismatch"),
  probability = c(4, 2, 1), impact = c(5, 3, 2),
  detectability = c(2, 3, 1)
)
rr <- create_risk_register(risks)
risk_indicator_summary(rr)

}
