% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{risk_config_default}
\alias{risk_config_default}
\title{Default Risk Configuration}
\usage{
risk_config_default(
  rpn_bands = list(critical = c(80, 125), high = c(40, 79), medium = c(15, 39), low =
    c(1, 14)),
  evidence_severity_to_probability = c(info = 1, low = 2, medium = 3, high = 4, critical
    = 5),
  evidence_severity_to_impact = c(info = 1, low = 2, medium = 3, high = 4, critical = 5),
  default_detectability = 3
)
}
\arguments{
\item{rpn_bands}{Named list of RPN band boundaries \code{c(lower, upper)}.
Evaluated in order; first match wins.}

\item{evidence_severity_to_probability}{Named numeric vector mapping
evidence severity to probability scores (1--5 scale).}

\item{evidence_severity_to_impact}{Named numeric vector mapping
evidence severity to impact scores (1--5 scale).}

\item{default_detectability}{Default detectability score (1--5) when not
explicitly provided. Lower = more detectable.}
}
\value{
A list of class \code{"risk_config"} with elements:
\code{rpn_bands}, \code{evidence_severity_to_probability},
\code{evidence_severity_to_impact}, \code{default_detectability}.
}
\description{
Returns configuration for risk assessment including FMEA scale definitions,
RPN thresholds, and risk level classification bands.
}
\details{
The FMEA-inspired risk model uses three dimensions:
\itemize{
\item \strong{Probability} (1--5): likelihood of the issue occurring/persisting
\item \strong{Impact} (1--5): severity of consequence if unresolved
\item \strong{Detectability} (1--5): difficulty of detecting the issue (1 = easy, 5 = hard)
}

\strong{RPN} = Probability x Impact x Detectability (range 1--125)
}
\examples{
cfg <- risk_config_default()
cfg$rpn_bands

}
