% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence_to_risk.R
\name{evidence_to_risks}
\alias{evidence_to_risks}
\title{Derive Risk Items from Evidence}
\usage{
evidence_to_risks(
  evidence,
  config = risk_config_default(),
  include_pass = FALSE
)
}
\arguments{
\item{evidence}{A validated evidence data.frame (from \code{r4subcore}).}

\item{config}{A \code{risk_config} from \code{\link[=risk_config_default]{risk_config_default()}}.}

\item{include_pass}{Logical; if \code{TRUE}, passing indicators are also
included as low-risk items. Default \code{FALSE}.}
}
\value{
A tibble suitable for \code{\link[=create_risk_register]{create_risk_register()}}.
}
\description{
Automatically generates risk items from an R4SUB evidence table.
Each failing or warning indicator becomes a potential risk, with
probability and impact inferred from evidence severity.
}
\details{
The mapping from evidence to risk uses:
\itemize{
\item \code{risk_id}: derived from \code{indicator_id} + \code{asset_id} via
\code{r4subcore::hash_id()}
\item \code{category}: mapped from \code{indicator_domain}
\item \code{probability}: mapped from evidence \code{severity} via config
\item \code{impact}: mapped from evidence \code{severity} via config
\item \code{detectability}: uses \code{config$default_detectability}
}

Multiple evidence rows for the same indicator + asset are aggregated:
probability and impact use the maximum across rows.
}
\examples{
\donttest{
ctx <- r4subcore::r4sub_run_context(study_id = "STUDY01")
ev <- r4subcore::as_evidence(
  data.frame(
    asset_type = "dataset", asset_id = "ADSL",
    source_name = "test", source_version = "1.0",
    indicator_id = "Q-001", indicator_name = "Test",
    indicator_domain = "quality", severity = "high",
    result = "fail", metric_value = 1, metric_unit = "n",
    message = "Example finding", location = "ADSL",
    evidence_payload = "{}", stringsAsFactors = FALSE
  ), ctx = ctx
)
risk_items <- evidence_to_risks(ev)
rr <- create_risk_register(risk_items)
}

}
