% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_register.R
\name{create_risk_register}
\alias{create_risk_register}
\title{Create a Risk Register}
\usage{
create_risk_register(risks, config = risk_config_default())
}
\arguments{
\item{risks}{A data.frame with at minimum columns \code{risk_id} and
\code{description}. Optional columns: \code{category}, \code{probability}, \code{impact},
\code{detectability}, \code{owner}, \code{mitigation}, \code{status}.}

\item{config}{A \code{risk_config} from \code{\link[=risk_config_default]{risk_config_default()}}.}
}
\value{
A tibble of class \code{"risk_register"} with standardized columns and
computed RPN values.
}
\description{
Builds a risk register from a user-supplied data.frame of identified risks.
Validates required columns and fills defaults.
}
\examples{
risks <- data.frame(
  risk_id     = c("R001", "R002", "R003"),
  description = c("Missing SDTM variables", "Unmapped ADaM derivations",
                   "Inconsistent define.xml"),
  category    = c("data_quality", "traceability", "documentation"),
  probability = c(4, 3, 2),
  impact      = c(5, 4, 3),
  detectability = c(2, 3, 4)
)
rr <- create_risk_register(risks)
rr

}
