% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_scores.R
\name{compute_risk_scores}
\alias{compute_risk_scores}
\title{Compute Risk Scores from a Risk Register}
\usage{
compute_risk_scores(risk_register, config = risk_config_default())
}
\arguments{
\item{risk_register}{A \code{risk_register} from \code{\link[=create_risk_register]{create_risk_register()}}.}

\item{config}{A \code{risk_config} from \code{\link[=risk_config_default]{risk_config_default()}}.}
}
\value{
A list of class \code{"risk_scores"} with:
\itemize{
\item \code{overall_risk_score}: 0--1 (0 = no risk, 1 = maximum risk)
\item \code{mean_rpn}: average RPN across all risks
\item \code{max_rpn}: highest individual RPN
\item \code{n_risks}: total risk count
\item \code{risk_distribution}: tibble of counts by risk_level
\item \code{category_summary}: tibble of mean RPN by category
}
}
\description{
Computes aggregate risk metrics from a risk register, including mean RPN,
risk distribution, and overall risk score normalized to 0--1.
}
\examples{
risks <- data.frame(
  risk_id = c("R001", "R002"),
  description = c("Missing vars", "Bad derivation"),
  probability = c(4, 2), impact = c(5, 3), detectability = c(2, 3)
)
rr <- create_risk_register(risks)
compute_risk_scores(rr)

}
