% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_mitigation.R
\name{compare_risk_registers}
\alias{compare_risk_registers}
\title{Compare Risk Registers (Trend Analysis)}
\usage{
compare_risk_registers(before, after)
}
\arguments{
\item{before}{A \code{risk_register} (earlier snapshot).}

\item{after}{A \code{risk_register} (later snapshot).}
}
\value{
A list with:
\itemize{
\item \code{rpn_changes}: tibble of risks with changed RPN
\item \code{new_risks}: risk_ids present in \code{after} but not \code{before}
\item \code{resolved_risks}: risk_ids present in \code{before} but not \code{after}
\item \code{level_transitions}: tibble of risk level changes
\item \code{delta_mean_rpn}: change in mean RPN
}
}
\description{
Compares two risk register snapshots and reports changes in RPN,
new risks, resolved risks, and risk level transitions.
}
\examples{
r1 <- data.frame(
  risk_id = c("R001", "R002"),
  description = c("Missing vars", "Bad derivation"),
  probability = c(4, 3), impact = c(5, 4), detectability = c(2, 3)
)
r2 <- data.frame(
  risk_id = c("R001", "R003"),
  description = c("Missing vars", "New issue"),
  probability = c(2, 3), impact = c(5, 3), detectability = c(2, 2)
)
rr1 <- create_risk_register(r1)
rr2 <- create_risk_register(r2)
compare_risk_registers(rr1, rr2)

}
