% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_mitigation.R
\name{apply_mitigations}
\alias{apply_mitigations}
\title{Update Risk Mitigation Status}
\usage{
apply_mitigations(risk_register, updates, config = risk_config_default())
}
\arguments{
\item{risk_register}{A \code{risk_register} from \code{\link[=create_risk_register]{create_risk_register()}}.}

\item{updates}{A data.frame with at minimum column \code{risk_id}, plus any
columns to update: \code{probability}, \code{impact}, \code{detectability},
\code{mitigation}, \code{status}.}

\item{config}{A \code{risk_config} from \code{\link[=risk_config_default]{risk_config_default()}}.}
}
\value{
An updated \code{risk_register} with recomputed RPN and risk levels.
}
\description{
Applies mitigation updates to a risk register. Allows updating
probability, impact, detectability, status, and mitigation notes
for specific risks.
}
\examples{
risks <- data.frame(
  risk_id = c("R001", "R002"),
  description = c("Missing vars", "Bad derivation"),
  probability = c(4, 3), impact = c(5, 4), detectability = c(2, 3)
)
rr <- create_risk_register(risks)

updates <- data.frame(
  risk_id     = "R001",
  probability = 2,
  mitigation  = "Added validation check",
  status      = "mitigated"
)
rr2 <- apply_mitigations(rr, updates)
rr2

}
