% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnqgate.R
\docType{class}
\name{cnqgate}
\alias{cnqgate}
\alias{cnqgate-class}
\title{n-fold controlled single qubit gate}
\description{
This class represents a generic n-fold controlled gate
}
\details{
The qubits are counted from 1 to \code{nbits} starting with the least
significant bit.
}
\section{Slots}{

\describe{
\item{\code{cbits}}{Integer. Integer vector of control bits.}

\item{\code{tbit}}{Integer. Target bit.}

\item{\code{gate}}{sqgate. The single qubit gate.}

\item{\code{inverse}}{Logical. Boolean vector of same length as \code{cbits}. If
\code{TRUE}, the corresponding control bit is negated.}
}}

\examples{
x <- H(1) * qstate(nbits=3)
## application of the CCX (CCNOT) gate to bits 1,2 and 3
z <- cnqgate(cbits=c(1L, 2L), tbit=3L, gate=X(3L)) * x
z
## the same, but differently implemented
z <- CCNOT(c(1,2,3)) * x
z

}
