% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\name{truth.table}
\alias{truth.table}
\title{Method truth.table}
\usage{
truth.table(e1, nbits, bits, ...)
}
\arguments{
\item{e1}{gate to measure.}

\item{nbits}{number of bits the gate acts on.}

\item{bits}{optional vector of length \code{nbits} containing the qubit order in the gate.}

\item{...}{additional parameters to passed be on to 'e1'}
}
\value{
returns a data.frame containing the truth table. Each row corresponds
to one input-output combination. Each column to one specific bit.
}
\description{
Method truth.table
}
\details{
calculates the quantum truth table of the gate \code{e1}.
If a basis state is transformed to a superposition of basis states by
the gate, the result is 'NA'.
}
\examples{
## truth table for a single bit gate
truth.table(X, 1)
## for a 2-bit gate
truth.table(CNOT, 2)
## for a 2-bit gate with reversed controll and target bits
truth.table(CNOT, bits=2:1)
## for a general controlled gate
truth.table(cqgate, 2, gate=H(2))
## for an arbitrary circuit (here a swap implementation using only CNOTs)
myswap <- function(bits){ function(x){ CNOT(bits) * (CNOT(rev(bits)) * (CNOT(bits) * x))}}
truth.table(myswap, 2)

}
