% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccqgate.R
\docType{class}
\name{ccqgate}
\alias{ccqgate}
\alias{ccqgate-class}
\title{A twice controlled single qubit gate}
\description{
This class represents a generic controlled gate
}
\details{
The qubits are counted from 1 to \code{nbits} starting with the least
significant bit.
}
\section{Slots}{

\describe{
\item{\code{bits}}{Integer. Integer vector of bits. The first two are the control bits, the third the target bit.}

\item{\code{gate}}{sqgate. The single qubit gate.}
}}

\examples{
x <- H(1) * qstate(nbits=3)
## application of the CCX (CCNOT) gate to bit 1,2,3
z <- ccqgate(bits=c(1L, 2L, 3L), gate=X(3L)) * x
z
## the same, but differently implemented
z <- CCNOT(c(1,2,3)) * x
z

}
