% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macro.R
\name{macro}
\alias{macro}
\alias{apply_macro}
\title{Resolve Macro Variables In A Text}
\usage{
macro(text)

apply_macro(character_vector)
}
\arguments{
\item{text}{A text containing macro variables to resolve.}

\item{character_vector}{A vector containing multiple character expressions in which
to resolve macro variables.}
}
\value{
\code{\link[=macro]{macro()}}: Returns a character.

\code{\link[=apply_macro]{apply_macro()}}: Returns a character vector.
}
\description{
Variables written with a leading "&" inside a text will be resolved into the
character or numeric expression the corresponding object is holding.
}
\details{
Macro variables in 'SAS' can be set up with \%Let and can act as global accessible
variables. This in itself is nothing special to 'R' because basically every object
created outside a function is a global variable.

To use these global objects within a text one has to use e.g. paste0("The current year is: ", year).
With the macro function one can write it like this: macro("The current year is &year").

So where is the benefit? If implemented within a function, a parameter like "title" or
"footnote" in the tabulation functions, can resolve these variables without the need
of another function. You can just pass the character expression "The current year is &year"
and the implementation inside the function resolves the macro variable directly in place.
}
\examples{
# Resolving macro variable in single character
year <- 2026

text <- macro("The current year is &year")

# You can also combine multiple macro variables
some_variable <- "current"
current2026   <- "The current year is"

text_combi <- macro("&&some_variable&year &year")

# Resolving macro variable in character vector
char_vector <- c("The current year is &year",
                 "The &some_variable year is &year",
                 "&&some_variable&year &year")

text_vector <- apply_macro(char_vector)

}
\seealso{
Functions that can make use of macro variables: \code{\link[=any_table]{any_table()}}, \code{\link[=frequencies]{frequencies()}},
\code{\link[=crosstabs]{crosstabs()}}, \code{\link[=export_with_style]{export_with_style()}}, \code{\link[=summarise_plus]{summarise_plus()}}, \code{\link[=transpose_plus]{transpose_plus()}}

Within the tabulation functions titles, footnotes, var_labels and stat_labels
can resolve macros. Additionally they can be used in the \code{\link[=any_table]{any_table()}} rows and
columns parameter, in the \code{\link[=summarise_plus]{summarise_plus()}} types parameter and in the \code{\link[=transpose_plus]{transpose_plus()}}
pivot parameter.
}
