% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw.R
\name{psw}
\alias{psw}
\alias{new_psw}
\alias{is_psw}
\alias{is_stabilized}
\alias{is_causal_wt}
\alias{as_psw}
\alias{estimand}
\alias{estimand<-}
\title{Propensity Score Weight Vectors}
\usage{
new_psw(
  x = double(),
  estimand = NULL,
  stabilized = FALSE,
  trimmed = FALSE,
  truncated = FALSE,
  calibrated = FALSE,
  ...
)

psw(
  x = double(),
  estimand = NULL,
  stabilized = FALSE,
  trimmed = FALSE,
  truncated = FALSE,
  calibrated = FALSE
)

is_psw(x)

is_stabilized(wt)

is_causal_wt(x)

as_psw(x, estimand = NULL)

estimand(wt)

estimand(wt) <- value
}
\arguments{
\item{x}{For \code{psw()} and \code{new_psw()}: a numeric vector of weights
(default: \code{double()}). For \code{is_psw()}, \code{is_causal_wt()}, and \code{as_psw()}:
an object to test or coerce.}

\item{estimand}{A character string identifying the target estimand (e.g.,
\code{"ate"}, \code{"att"}, \code{"ato"}). Defaults to \code{NULL}.}

\item{stabilized}{Logical. Were the weights stabilized? Defaults to \code{FALSE}.}

\item{trimmed}{Logical. Were the weights derived from trimmed propensity
scores? Defaults to \code{FALSE}.}

\item{truncated}{Logical. Were the weights derived from truncated propensity
scores? Defaults to \code{FALSE}.}

\item{calibrated}{Logical. Were the weights derived from calibrated
propensity scores? Defaults to \code{FALSE}.}

\item{...}{Additional attributes stored on the object (developer use only).}

\item{wt}{A \code{psw} or \code{causal_wts} object.}

\item{value}{A character string: the new estimand to assign.}
}
\value{
\itemize{
\item \code{new_psw()}, \code{psw()}, \code{as_psw()}: A \code{psw} vector.
\item \code{is_psw()}, \code{is_causal_wt()}, \code{is_stabilized()}: A single logical value.
\item \code{estimand()}: A character string, or \code{NULL} if no estimand is set.
\item \verb{estimand<-}: The modified \code{psw} object (called for its side effect).
}
}
\description{
\code{psw} objects are numeric vectors that carry metadata about propensity score
weights, including the target estimand and whether the underlying propensity
scores were trimmed, truncated, or calibrated.

Most users will encounter \code{psw} objects as return values from \code{\link[=wt_ate]{wt_ate()}} and
related weight functions. These constructor and helper functions are useful
for inspecting weight objects or for package developers extending propensity.
}
\details{
\subsection{Constructors}{
\itemize{
\item \code{psw()} is the \strong{user-facing} constructor. It coerces \code{x} to double and
validates inputs before creating the object.
\item \code{new_psw()} is the \strong{low-level} constructor intended for developers. It
assumes \code{x} is already a double vector and performs minimal validation.
\item \code{as_psw()} coerces an existing numeric vector to a \code{psw} object.
}
}

\subsection{Queries}{
\itemize{
\item \code{is_psw()} tests whether an object is a \code{psw} vector.
\item \code{is_causal_wt()} tests whether an object inherits from the broader
\code{causal_wts} class (which includes \code{psw} objects).
\item \code{estimand()} and \verb{estimand<-} get and set the estimand attribute.
\item \code{is_stabilized()} returns \code{TRUE} if the weights are stabilized.
}
}

\subsection{Arithmetic and combining}{

Arithmetic operations on \code{psw} objects preserve the class and attributes,
so operations like normalization (\code{weights / sum(weights)}) retain metadata.
Combining \code{psw} objects with \code{\link[=c]{c()}} preserves the class only when all
metadata matches; mismatched metadata produces a warning and falls back to a
plain numeric vector.

Subsetting with \code{[} preserves class and attributes. Summary functions
(\code{\link[=sum]{sum()}}, \code{\link[=mean]{mean()}}, etc.) return plain numeric values.
}
}
\examples{
# Create psw objects directly
w <- psw(c(1.2, 0.8, 1.5), estimand = "ate")
w

# Query metadata
is_psw(w)
estimand(w)
is_stabilized(w)

# Coerce a plain numeric vector
as_psw(c(1.0, 2.0), estimand = "att")

# Arithmetic preserves the psw class
w / sum(w)

# Combining: compatible metadata is preserved
x <- psw(c(1.2, 0.8), estimand = "ate")
y <- psw(c(1.1, 0.9), estimand = "ate")
c(x, y)

# Combining: incompatible metadata warns and returns numeric
x <- psw(c(1.2, 0.8), estimand = "ate")
y <- psw(c(1.1, 0.9), estimand = "att")
c(x, y)

}
\seealso{
\code{\link[=wt_ate]{wt_ate()}}, \code{\link[=wt_att]{wt_att()}}, \code{\link[=wt_atu]{wt_atu()}}, \code{\link[=wt_atm]{wt_atm()}}, \code{\link[=wt_ato]{wt_ato()}} for
calculating propensity score weights (which return \code{psw} objects).

\code{\link[=ps_trim]{ps_trim()}}, \code{\link[=ps_trunc]{ps_trunc()}}, and \code{\link[=ps_calibrate]{ps_calibrate()}} for modifying propensity
scores before weight calculation.
}
