\name{genRidgePenaltyMat}
\alias{genRidgePenaltyMat}
\title{
Penalty parameter matrix for generalized ridge regression.
}
\description{
The function produces an unscaled penalty parameter matrix to be used in the generalized ridge regression estimator.
}
\usage{
genRidgePenaltyMat(pr, pc=pr, type="2dimA")
}
\arguments{
\item{pr}{ A positive \code{integer}. The number of covariates if \code{type="common"} or 
\code{type="fused1dim"}. Or, the row dimension of a 2-dimensional covariate layout if \code{type="fused2dimA"} or \code{type="fused2dimD"}.}
\item{pc}{ A positive \code{integer}. The column dimension of a 2-dimensional covariate layout if \code{type="fused2dimA"} or \code{type="fused2dimD"}. Ignored if \code{type="common"} or \code{type="fused1dim"}. }
\item{type}{ A \code{character}. Either \code{"common"}, \code{"fused1dim"}, \code{"fused2dimA"} or \code{"fused2dimD"}, see details. }
}
\value{
The function returns a non-negative definite \code{matrix}.
}
\details{
Various ridge penalty matrices are implemented. 

The \code{type="common"}-option supports the `homogeneity' ridge penalization proposed by Anatolyev (2020). The ridge penalty matrix \eqn{\mathbf{\Delta}} for a \eqn{p}-dimensional regression parameter \eqn{\boldsymbol{\beta}} is such that:
\deqn{
\boldsymbol{\beta}^{\top} \mathbf{\Delta} \boldsymbol{\beta} \, \, = \, \, \boldsymbol{\beta}^{\top} ( \mathbf{I}_{pp} - p^{-1} \mathbf{1}_{pp}) \boldsymbol{\beta}  \, \, =  \, \, \sum\nolimits_{j=1}^p \big( \beta_j -
p^{-1} \sum\nolimits_{j'=1}^p \beta_{j'}\big)^2.
}{ This is a test with the text representation. }
This penalty matrix encourages shrinkage of the elements of \eqn{\boldsymbol{\beta}} to a common effect value.

The \code{type="fused1dim"}-option facilitates the 1-dimensional fused ridge estimation of Goeman (2008). The ridge penalty matrix \eqn{\mathbf{\Delta}} for a \eqn{p}-dimensional regression parameter \eqn{\boldsymbol{\beta}} is such that:
\deqn{
\boldsymbol{\beta}^{\top} \mathbf{\Delta} \boldsymbol{\beta} \, \, = \, \, \sum\nolimits_{j=2}^p ( \beta_{j} - \beta_{j-1} )_2^2.
}
This penalty matrix aims to shrink contiguous (as defined by their index) elements of \eqn{\boldsymbol{\beta}} towards each other.


The \code{type="fused2dimA"}- and  \code{type="fused2dimD"}-options facilitate 2-dimensional ridge estimation as proposed by Lettink et al. (2022). It assumes the regression parameter is endowed with a 2-dimensional layout. The columns of this layout have been stacked to form \eqn{\boldsymbol{\beta}}. The 2-dimensional fused ridge estimation shrinks elements of \eqn{\boldsymbol{\beta}} that are neighbors in the 2-dimensional layout towards each other. The two options use different notions of neighbors. If \code{type="fused2dimA"}, the ridge penalty matrix \eqn{\mathbf{\Delta}} for a \eqn{p}-dimensional regression parameter \eqn{\boldsymbol{\beta}} is such that:
\deqn{
\boldsymbol{\beta}^{\top} \mathbf{\Delta} \boldsymbol{\beta} \, \,  = \, \,  \sum\nolimits_{j_r=1}^{p_r-1} \sum\nolimits_{j_c=1}^{p_c-1} [(\beta_{j_r,j_c+1} - \beta_{j_r,j_c})^2 + (\beta_{j_r+1, j_c} - \beta_{j_r, j_c})^2]
}
\deqn{
\mbox{ } \qquad \qquad \, \, \, \, + \sum\nolimits_{j_c=1}^{p_c-1} (\beta_{p_r,j_c+1} - \beta_{p_r,j_c})^2 +  \sum\nolimits_{j_r=1}^{p_r-1}  (\beta_{j_r+1, p_c} - \beta_{j_r, p_c})^2,
}
where \eqn{p_r} and \eqn{p_c} are the row and column dimension, respectively, of the 2-dimensional layout. This penalty matrix intends to shrink the elements of \eqn{\boldsymbol{\beta}} along the axes of the 2-dimensional layout. If \code{type="fused2dimD"}, the ridge penalty matrix \eqn{\mathbf{\Delta}} for a \eqn{p}-dimensional regression parameter \eqn{\boldsymbol{\beta}} is such that:
\deqn{
\boldsymbol{\beta}^{\top} \mathbf{\Delta} \boldsymbol{\beta} \, \,  = \, \, 
\sum\nolimits_{j_r=1}^{p_r-1} \sum\nolimits_{j_c=1}^{p_c-2}  [(\beta_{j_r+1,j_c} - \beta_{j_r,j_c+1})^2 + (\beta_{j_r+1, j_c+2} - \beta_{j_r, j_c+1})^2]
}
\deqn{
\mbox{ } \qquad \, + \sum\nolimits_{j_r=1}^{p_r-1} [(\beta_{j_r+1,2} - \beta_{j_r,1})^2 + (\beta_{j_r+1, p_c-1} - \beta_{j_r, p_c})^2].
}
This penalty matrix shrinks the elements of \eqn{\boldsymbol{\beta}} along the diagonally to the axes of the 2-dimensional layout. The penalty matrices 
generated by \code{type="fused2dimA"}- and  \code{type="fused2dimD"}-options may be combined. 
}
\author{
W.N. van Wieringen.
}
\references{
Anatolyev, S. (2020), "A ridge to homogeneity for linear models", \emph{Journal of Statistical Computation and Simulation}, 90(13), 2455-2472.

Goeman, J.J. (2008), "Autocorrelated logistic ridge regression for prediction based on proteomics spectra", \emph{Statistical Applications in Genetics and Molecular Biology}, 7(2).

Lettink, A, Chinapaw, M.J.M., van Wieringen, W.N. (2022), "Two-dimensional fused targeted ridge regression for health indicator prediction from accelerometer data", \emph{submitted}.
}
\seealso{
\code{ridgeGLM}
}
\examples{
# generate unscaled general penalty parameter matrix
Dfused <- genRidgePenaltyMat(10, type="fused1dim")
}
