% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piqp.R
\name{piqp}
\alias{piqp}
\title{PIQP Solver object}
\usage{
piqp(
  P = NULL,
  c = NULL,
  A = NULL,
  b = NULL,
  G = NULL,
  h_l = NULL,
  h_u = NULL,
  x_l = NULL,
  x_u = NULL,
  settings = list(),
  backend = c("auto", "sparse", "dense")
)
}
\arguments{
\item{P}{dense or sparse matrix of class dgCMatrix or coercible into such, must be positive semidefinite}

\item{c}{numeric vector}

\item{A}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{b}{numeric vector}

\item{G}{dense or sparse matrix of class dgCMatrix or coercible into such}

\item{h_l}{numeric vector of lower inequality bounds, default \code{NULL}
indicating \code{-Inf} for all inequality constraints}

\item{h_u}{numeric vector of upper inequality bounds, default \code{NULL}
indicating \code{Inf} for all inequality constraints}

\item{x_l}{a numeric vector of lower variable bounds, default \code{NULL}
indicating \code{-Inf} for all variables}

\item{x_u}{a numeric vector of upper variable bounds, default \code{NULL}
indicating \code{Inf} for all variables}

\item{settings}{list with optimization parameters, empty by default; see \code{\link[=piqp_settings]{piqp_settings()}} for a comprehensive list of parameters that may be used}

\item{backend}{which backend to use, if auto and P, A or G are sparse then sparse backend is used (\code{"auto"}, \code{"sparse"} or \code{"dense"}) (\code{"auto"})}
}
\value{
An S7 object of class "piqp_model" with methods
\code{solve()}, \code{update()}, \code{\link[=get_settings]{get_settings()}}, \code{\link[=get_dims]{get_dims()}}, \code{\link[=update_settings]{update_settings()}}
which can be used to solve the problem with updated settings / parameters.
}
\description{
PIQP Solver object
}
\details{
Allows one to solve a parametric
problem with for example warm starts between updates of the parameter, c.f. the examples.
The object returned by \code{piqp} contains several methods which can be used to either update/get details of the
problem, modify the optimization settings or attempt to solve the problem.
}
\section{Usage}{

\preformatted{model = piqp(P = NULL, c = NULL, A = NULL, b = NULL, G = NULL,
             h_l = NULL, h_u = NULL, x_l = NULL, x_u = NULL,
             settings = piqp_settings(),
             backend = c("auto", "sparse", "dense"))

solve(model)
update(model, P = NULL, c = NULL, A = NULL, b = NULL, G = NULL,
       h_l = NULL, h_u = NULL, x_l = NULL, x_u = NULL)
get_settings(model)
get_dims(model)
update_settings(model, new_settings = piqp_settings())

}
}

\examples{
## example, adapted from PIQP documentation
library(piqp)
library(Matrix)

P <- Matrix(c(6., 0.,
              0., 4.), 2, 2, sparse = TRUE)
c <- c(-1., -4.)
A <- Matrix(c(1., -2.), 1, 2, sparse = TRUE)
b <- c(1.)
G <- Matrix(c(1., 2., -1., 0.), 2, 2, sparse = TRUE)
h_u <- c(0.2, -1.)
x_l <- c(-1., -Inf)
x_u <- c(1., Inf)

settings <- list(verbose = TRUE)

model <- piqp(P, c, A, b, G, h_u = h_u, x_l = x_l, x_u = x_u, settings = settings)

# Solve
res <- solve(model)
res$x

# Define new data
A_new <- Matrix(c(1., -3.), 1, 2, sparse = TRUE)
h_u_new <- c(2., 1.)

# Update model and solve again
update(model, A = A_new, h_u = h_u_new)
res <- solve(model)
res$x

}
\seealso{
\code{\link[=solve_piqp]{solve_piqp()}},  \code{\link[=piqp_settings]{piqp_settings()}}
}
