% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{insert_gaps2_vec}
\alias{insert_gaps2_vec}
\title{Insert gaps into an ungapped sequence based on a gapped reference sequence.}
\usage{
insert_gaps2_vec(gapped, ungapped, parallel = FALSE)
}
\arguments{
\item{gapped}{A vector of strings representing the reference sequences with gaps.}

\item{ungapped}{A vector of strings representing the sequences without gaps.}

\item{parallel}{A boolean flag to enable parallel processing (default: FALSE).}
}
\value{
A vector of strings with gaps inserted to match the gapped reference.
}
\description{
This function inserts gaps (e.g., \code{.} or \code{-}) into an ungapped sequence (\code{ungapped})
to match the positions of gaps in a reference sequence (\code{gapped}). It ensures that
the aligned sequence has the same gap structure as the reference.
}
\examples{
# Example usage
gapped <- c("caggtc..aact", "caggtc---aact")
ungapped <- c("caggtcaact", "caggtcaact")

# Sequential execution
result <- insert_gaps2_vec(gapped, ungapped, parallel = FALSE)
print(result)  # "caggtc..aact", "caggtc---aact"

# Parallel execution
result_parallel <- insert_gaps2_vec(gapped, ungapped, parallel = TRUE)
print(result_parallel)

}
