% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_param.R
\name{safe_param}
\alias{safe_param}
\title{Safely extract and coerce a value from a Power BI parameter table}
\usage{
safe_param(
  params_or_value,
  col = NULL,
  row = 1,
  target = c("numeric", "integer", "character", "logical", "date", "datetime"),
  default = NULL,
  integer_strategy = c("round", "floor", "ceiling", "truncate"),
  make_positive = FALSE,
  min_val = -Inf,
  max_val = Inf,
  trim_ws = TRUE,
  na_values = c("", "NA", "NaN", "null", "Null", "NULL"),
  date_formats = c("\%Y-\%m-\%d", "\%m/\%d/\%Y", "\%d-\%b-\%Y", "\%Y/\%m/\%d"),
  tz = "UTC"
)
}
\arguments{
\item{params_or_value}{A `data.frame` (the Power BI parameter table) **or**
a bare scalar value. When a scalar is supplied, `col` and `row` are
ignored and the value is coerced directly.}

\item{col}{Character. Column name to extract from the data.frame. Required
when `params_or_value` is a data.frame; ignored otherwise.}

\item{row}{Integer. Row index to extract (default `1`). Power BI parameter
tables always have exactly one row, so this rarely needs changing.}

\item{target}{Character. Target type for coercion. One of `"numeric"`,
`"integer"`, `"character"`, `"logical"`, `"date"`, `"datetime"`.}

\item{default}{The value returned when the extracted value is `NA` or
missing. Defaults to `NULL`, which causes a typed `NA` to be returned.}

\item{integer_strategy}{Character. How to convert a non-integer numeric to
integer. One of `"round"` (default), `"floor"`, `"ceiling"`,
`"truncate"`.}

\item{make_positive}{Logical. If `TRUE`, the absolute value is taken before
clamping. Only applies to `"numeric"` and `"integer"` targets.}

\item{min_val}{Numeric. Lower bound for numeric/integer output (inclusive).
Default `-Inf` (no lower bound).}

\item{max_val}{Numeric. Upper bound for numeric/integer output (inclusive).
Default `Inf` (no upper bound).}

\item{trim_ws}{Logical. If `TRUE` (default), leading/trailing whitespace is
stripped from character values before processing.}

\item{na_values}{Character vector of strings that should be treated as `NA`.
Default: `c("", "NA", "NaN", "null", "Null", "NULL")`.}

\item{date_formats}{Character vector of `strptime` format strings tried in
order when parsing dates. Default covers ISO 8601, US, and abbreviated
month formats.}

\item{tz}{Character. Time zone used for `"datetime"` targets and when
converting between date and datetime types. Default `"UTC"`.}
}
\value{
A scalar of the requested type, or a typed `NA` / `default` when
  the value is missing or cannot be coerced.
}
\description{
Extracts a single value from a Power BI parameter data.frame (1 row,
multiple columns) and coerces it to the requested type. All coercion is
done programmatically — values are never spliced as raw strings into SQL,
DAX, or file paths, eliminating injection risk.
}
\examples{
params <- data.frame(
  StartDate = "2024-01-01",
  TopN      = "10",
  Region    = "North",
  Debug     = "true",
  stringsAsFactors = FALSE
)

safe_param(params, "StartDate", target = "date")
safe_param(params, "TopN",      target = "integer", default = 5L, min_val = 1L)
safe_param(params, "Region",    target = "character", default = "All")
safe_param(params, "Debug",     target = "logical",   default = FALSE)

# Scalar usage (no data.frame)
safe_param("42.7", target = "integer", integer_strategy = "floor")

}
