% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_it_metrics.R
\name{calculate_it_metrics}
\alias{calculate_it_metrics}
\title{Calculate Landscape Complexity Metrics (IT Metrics) per Polygon}
\usage{
calculate_it_metrics(landscape_raster, aoi_sf)
}
\arguments{
\item{landscape_raster}{A \code{SpatRaster} object representing the categorical
landscape (e.g., LULC).}

\item{aoi_sf}{An \code{sf} object containing polygonal geometries (e.g., H3
hexagons) for which the landscape metrics should be calculated.}
}
\value{
An \code{sf} object identical to \code{aoi_sf}, but with new columns
  appended. The new columns represent the calculated landscape metrics (e.g.,
  \code{lsm_shdi}) with an \code{lsm_} prefix.
}
\description{
Calculates specified landscape complexity metrics (a subset of Information Theory
metrics) from a categorical land-cover raster for each input polygon using
\code{landscapemetrics::sample_lsm()}. This function ensures a safe, alignment-guaranteed
join of the results back to the original geometry.
}
\details{
This function calculates metrics at the \code{"landscape"} level, filtering for
\code{"complexity metric"} types. The function prioritizes data integrity by
adding a temporary \code{plot_id} column based on row index, which is used
by \code{landscapemetrics}.

Crucially, the function uses \code{dplyr::left_join} with this \code{plot_id}
for merging the results. This **robust join method** prevents data misalignment
that could occur if rows were dropped during metric calculation, which is a significant
improvement over the unsafe \code{cbind} method. The temporary \code{plot_id} column
is removed before the final object is returned.
}
\examples{
\dontrun{
# Assuming 'lulc' is a SpatRaster and 'hex_grid_sf' is an sf polygon grid
# metrics_sf <- calculate_it_metrics(lulc, hex_grid_sf)
# head(metrics_sf)
}
}
\seealso{
\code{\link[landscapemetrics]{sample_lsm}} for available metrics.
}
