% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmapi_changeset_discussion.R
\name{osm_search_comment_changeset_discussion}
\alias{osm_search_comment_changeset_discussion}
\title{Search changeset comments}
\usage{
osm_search_comment_changeset_discussion(
  user,
  from,
  to,
  format = c("R", "xml", "json"),
  tags_in_columns = FALSE
)
}
\arguments{
\item{user}{Search for changeset comments created by the user with the given user id (numeric) or display name
(character).}

\item{from}{Beginning date range. See details for the valid formats.}

\item{to}{End date range. Only works when \code{from} is supplied. See details for the valid formats.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"xml"}, or \code{"json"}.}

\item{tags_in_columns}{If \code{FALSE} (default), the tags of the changesets are saved in a single list column \code{tags}
containing a \code{data.frame} for each changeset with the keys and values. If \code{TRUE}, add a column for each key.
Ignored if \code{format != "R"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one comment per  If \code{format = "xml"}, returns a
\link[xml2:oldclass]{xml2::xml_document}. If \code{format = "json"}, returns a list with the json structure.
}
\description{
Returns changeset comments that match the specified query. If no query is provided, the most recent changeset
comments are returned.
}
\details{
The valid formats for \code{from} and \code{to} parameters are \link{POSIXt} values or characters preferably in
\href{https://en.wikipedia.org/wiki/ISO_8601}{ISO 8601} format.
}
\examples{
# See the latest changeset comments globally:
osm_search_comment_changeset_discussion()

# Search for changeset comments by a specific user:
osm_search_comment_changeset_discussion(user = "Steve", format = "json")

# Search for changeset comments between January 1st and January 2nd, 2015:
osm_search_comment_changeset_discussion(from = "2015-01-01", to = "2015-01-02", format = "xml")
}
\seealso{
Other changeset discussion's functions: 
\code{\link{osm_comment_changeset_discussion}()},
\code{\link{osm_hide_comment_changeset_discussion}()},
\code{\link{osm_subscribe_changeset_discussion}()}
}
\concept{changeset discussion's functions}
