% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find.R
\name{find_patients}
\alias{find_patients}
\title{Finds patients in Orthanc according to queries and labels}
\usage{
find_patients(
  client,
  query = list(),
  labels = character(),
  labels_constraint = "All",
  ...
)
}
\arguments{
\item{client}{Orthanc API client.}

\item{query}{Named-list that specifies the filters on the level related DICOM
tags.}

\item{labels}{Character vector of labels to look for in resources.}

\item{labels_constraint}{Contraint on the labels ('All', 'Any', 'None').}

\item{...}{Additional arguments passed to \code{query_orthanc}.}
}
\value{
A \code{list} of \link{Patient} objects.
}
\description{
Finds patients in Orthanc according to queries and labels
}
\examples{
client <- Orthanc$new("https://orthanc.uclouvain.be/demo")
find_patients(client, query = list(PatientName = "HN_P001"))
}
