% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Job.R
\name{Job}
\alias{Job}
\title{Job Class}
\value{
An instance of \code{Job}.
}
\description{
Job class to follow a Job in Orthanc
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{state}}{Job state.}

\item{\code{content}}{Job content.}

\item{\code{type}}{Job type.}

\item{\code{creation_time}}{Job creation time.}

\item{\code{effective_runtime}}{Job effective runtime.}

\item{\code{priority}}{Job priority.}

\item{\code{progress}}{Job progress.}

\item{\code{error}}{Job error.}

\item{\code{error_details}}{Job error details.}

\item{\code{timestamp}}{Job timestamp.}

\item{\code{completion_time}}{Job completion time.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Job-new}{\code{Job$new()}}
\item \href{#method-Job-wait_until_completion}{\code{Job$wait_until_completion()}}
\item \href{#method-Job-get_information}{\code{Job$get_information()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-new"></a>}}
\if{latex}{\out{\hypertarget{method-Job-new}{}}}
\subsection{Method \code{new()}}{
Create a new Job instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$new(id, client)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Job ID.}

\item{\code{client}}{Orthanc API client.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-wait_until_completion"></a>}}
\if{latex}{\out{\hypertarget{method-Job-wait_until_completion}{}}}
\subsection{Method \code{wait_until_completion()}}{
Stop execution until job is not Pending/Running.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$wait_until_completion(interval = 2L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interval}}{Time interval to check the job status, default is 2s.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Job-get_information"></a>}}
\if{latex}{\out{\hypertarget{method-Job-get_information}{}}}
\subsection{Method \code{get_information()}}{
Get job information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Job$get_information()}\if{html}{\out{</div>}}
}

}
}
