% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{v_xypair}
\alias{v_xypair}
\title{Validator for XY Pair Lists}
\usage{
v_xypair(min_len = 1, max_len = NULL)
}
\arguments{
\item{min_len}{Minimum length required for the \code{x} and \code{y} vectors.
Defaults to 1.}

\item{max_len}{Maximum length allowed for the \code{x} and \code{y} vectors.
Defaults to \code{NULL} (no upper bound).}
}
\value{
A validator function that takes a value (typically a list with \code{x}
and \code{y} components) and raises an error if:
\itemize{
\item The value is not a list
\item The list does not contain both \code{x} and \code{y} named elements
\item Either \code{x} or \code{y} is NULL
\item Either \code{x} or \code{y} is not an atomic vector
\item Either \code{x} or \code{y} contains NA values
\item The \code{x} and \code{y} vectors have different lengths
\item The vectors are shorter than \code{min_len}
\item The vectors are longer than \code{max_len} (when \code{max_len} is not \code{NULL})
}
}
\description{
\code{v_xypair()} returns a validator function that checks if a value is a list
with paired \code{x} and \code{y} components of equal length. This is useful for
validating paired data structures in options managers created with
\code{\link[=create_options_manager]{create_options_manager()}}.
}
\examples{
# Create a validator for XY pairs with minimum length 2
validator <- v_xypair(min_len = 2)

# Valid input
validator(list(x = c(1, 2, 3), y = c(10, 20, 30)))

# Invalid inputs (would raise errors)
try(validator(list(x = c(1), y = c(10))))
try(validator(list(x = c(1, 2), y = c(10, 20, 30)))) # different lengths
try(validator(list(x = c(1, NA), y = c(10, 20)))) # contains NA
try(validator(list(x = c(1, 2)))) # missing y
}
