% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xl_open.R
\name{xl_open}
\alias{xl_open}
\alias{xl_open.wbWorkbook}
\alias{xl_open.default}
\title{Open a file or workbook object in spreadsheet software}
\usage{
xl_open(x, interactive = NA, flush = FALSE)

\method{xl_open}{wbWorkbook}(x, interactive = NA, flush = FALSE)

\method{xl_open}{default}(x, interactive = NA, flush = FALSE)
}
\arguments{
\item{x}{A character string specifying the path to a spreadsheet file or
a \link{wbWorkbook} object.}

\item{interactive}{Logical; if \code{FALSE}, the function will not attempt to
launch the application. Defaults to the result of \code{\link[base:interactive]{base::interactive()}}.}

\item{flush}{Logical; if \code{TRUE}, the workbook is written to the temporary
location using the stream-based XML parser. See \code{\link[=wb_save]{wb_save()}} for details.}
}
\description{
\code{xl_open()} is a portable utility designed to open spreadsheet files (such
as .xlsx or .xls) or \link{wbWorkbook} objects using the appropriate application
based on the host operating system. It handles the nuances of background
execution to ensure the R interpreter remains unblocked.
}
\details{
The method for identifying and launching the software varies by platform:

\strong{Windows} utilizes \code{shell.exec()} to trigger the file association
registered with the operating system.

\strong{macOS} utilizes the system \code{open} command, which respects default
application handlers for the file type. Users can override the default by
setting \code{options("openxlsx2.excelApp")}.

\strong{Linux} attempts to locate common spreadsheet utilities in the system
path, including LibreOffice (\code{soffice}), Gnumeric (\code{gnumeric}), Calligra
Sheets (\code{calligrasheets}), and ONLYOFFICE (\code{onlyoffice-desktopeditors}).
If multiple applications are found during an interactive session, a menu is
presented to the user to define their preference, which is then stored in
\code{options("openxlsx2.excelApp")}.

For \code{wbWorkbook} objects, the function automatically clones the workbook,
detects the presence of macros (VBA) to determine the appropriate temporary
file extension, and saves the content to a temporary location before opening.
}
\examples{
\donttest{
if (interactive()) {
  xlsx_file <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
  xl_open(xlsx_file)

  # (not yet saved) Workbook example
  wb <- wb_workbook()
  x <- mtcars[1:6, ]
  wb$add_worksheet("Cars")
  wb$add_data("Cars", x, start_col = 2, start_row = 3, row_names = TRUE)
  xl_open(wb)
}
}
}
