% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_protect}
\alias{wb_protect}
\title{Protect a workbook from modifications}
\usage{
wb_protect(
  wb,
  protect = TRUE,
  password = NULL,
  lock_structure = FALSE,
  lock_windows = FALSE,
  type = 1,
  file_sharing = FALSE,
  username = unname(Sys.info()["user"]),
  read_only_recommended = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object}

\item{protect}{Whether to protect or unprotect the sheet (default \code{TRUE})}

\item{password}{(optional) password required to unprotect the workbook}

\item{lock_structure}{Whether the workbook structure should be locked}

\item{lock_windows}{Whether the window position of the spreadsheet should be
locked}

\item{type}{Lock type (see \strong{Details})}

\item{file_sharing}{Whether to enable a popup requesting the unlock password
is prompted}

\item{username}{The username for the \code{file_sharing} popup}

\item{read_only_recommended}{Whether or not a post unlock message appears
stating that the workbook is recommended to be opened in read-only mode.}

\item{...}{additional arguments}
}
\description{
Protect or unprotect a workbook from modifications by the user in the
graphical user interface. Replaces an existing protection. While
passwords can be unicode characters, spreadsheet software is often
unable to process these. Therefore using ascii characters is recommended.
}
\details{
This protection only adds XML strings to the workbook. It will not encrypt
the file. For a full file encryption have a look at the \code{msoc} package.

If the \code{openssl} package is installed, a SHA based password hash will be
used. The legacy implementation not using \code{openssl} is prune to collisions.

Lock types:
\itemize{
\item \code{1}  xlsx with password (default)
\item \code{2} xlsx recommends read-only
\item \code{4} xlsx enforces read-only
\item \code{8} xlsx is locked for annotation
}
}
\note{
The cryptographic hashing implementation used here has not been
independently reviewed for security. It should not be used for
production-level security or sensitive data without formal auditing.
}
\examples{
\donttest{
wb <- wb_workbook()
wb$add_worksheet("S1")
wb_protect(wb, protect = TRUE, password = "Password", lock_structure = TRUE)

# Remove the protection
wb_protect(wb, protect = FALSE)

wb <- wb_protect(
  wb,
  protect = TRUE,
  password = "Password",
  lock_structure = TRUE,
  type = 2L,
  file_sharing = TRUE,
  username = "Test",
  read_only_recommended = TRUE
)
}
}
\seealso{
\link{wb_protect_worksheet}
}
