% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\docType{package}
\name{nzilbb.labbcat}
\alias{nzilbb.labbcat}
\alias{nzilbb.labbcat-package}
\title{\packageTitle{nzilbb.labbcat}}
\description{
\packageDescription{nzilbb.labbcat}
}
\details{
\packageDESCRIPTION{nzilbb.labbcat}
\packageIndices{nzilbb.labbcat}

'LaBB-CAT' is a web-based language corpus management system and this
package provides access to data stored in a 'LaBB-CAT' instance.
You must have at least version 20230818.1400 'LaBB-CAT' to use
this package.
}
\examples{
\dontrun{
## Perform a search
results <- getMatches(labbcat.url, list(segment="I")) |>
    ## Get the phonemic transcriptions for the matches
    appendLabels("phonemes")

## Get sound fragments for the matches
wav.files <- getSoundFragments(labbcat.url, results$Transcript, results$Line, results$LineEnd)
}

}
\references{
\cite{Robert Fromont and Jennifer Hay, "{ONZE Miner}: the development of a browser-based research tool", 2008}
\cite{Robert Fromont, "Toward a format-neutral annotation store", 2017}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://nzilbb.github.io/labbcat-R/}
  \item \url{https://labbcat.canterbury.ac.nz}
  \item Report bugs at \url{https://github.com/nzilbb/labbcat-R/issues}
}

}
\author{
\packageAuthor{nzilbb.labbcat}
}
\keyword{internal}
