% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentData.R
\name{fragmentData}
\alias{fragmentData}
\title{Gets binary annotation data in fragments.}
\usage{
fragmentData(
  matches,
  layer.id,
  path = "",
  no.progress = FALSE,
  start.column = Line,
  end.column = LineEnd,
  labbcat.url = NULL
)
}
\arguments{
\item{matches}{A dataframe returned by \link{getMatches} or \link{getAllUtterances}, identifying
the results to which acoustic measurments should be appended.}

\item{layer.id}{The ID of the MIME-typed layer.}

\item{path}{Optional path to directory where the files should be saved.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}

\item{start.column}{The column of \code{matches} containing the start time in seconds.}

\item{end.column}{The column of \code{matches} containing the end time in seconds.}

\item{labbcat.url}{URL to the LaBB-CAT instance (instead of inferring it from \code{matches}).}
}
\value{
\code{matches} with the acoustic measurements appended as new columns.
}
\description{
This is a version of \link{getFragmentAnnotationData} that can have a
dataframe of matches piped into it.
}
\details{
In some annotation layers, the annotations have not only a textual label, but also
binary data associated with it; e.g. an image or a data file. In these cases, the 'type'
of the layer is a MIME type, e.g. 'image/png'.
This function gets annotations between given start/end times on the given MIME-typed
layer, and retrieves the binary data as files, whose names are returned by the function.
}
\examples{
\dontrun{
## Get all tokens of "vivid"
vivid.tokens <- getMatches(labbcat.url, "vivid")
## Get mediapipe image annotations for during the tokens
vivid.faces <- vivid.tokens |>
    fragmentData(
        "mediapipe", path = "png",
        start.column=Target.word.start, end.column=Target.word.end)
}
}
\seealso{
\itemize{
\item \link{processWithPraat}
\item \link{getMatches}
}
}
\keyword{praat}
