% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_detention_admissions.R
\name{nyc_detention_admissions}
\alias{nyc_detention_admissions}
\title{NYC Detention Admissions by Community District}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/2hrw-qfsu>
}
\usage{
nyc_detention_admissions(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing NYC Detention Admissions by Community District data.
}
\description{
Downloads Detention Admissions by Community District data from NYC Open Data.
}
\details{
This dataset reports annual counts of detention admissions across NYC community
districts, disaggregated by borough and calendar year. Provided by the NYC
Department of Correction and Department of Youth and Community Development.
}
\examples{
# Examples that hit the live NYC Open Data API are guarded so CRAN checks
# do not fail when the network is unavailable or slow.
if (interactive() && curl::has_internet()) {
  # Quick example (fetch 2 rows)
  small_sample <- nyc_detention_admissions(limit = 2)
  small_sample

  nyc_detention_admissions(limit = 2, filters = list(borough = "Bronx"))
}
}
